% Simulate the CLLP with differen matricies for global passage numerically

% better clear all variables :)
clear;

% For Global Passages. Note: The easiest to implement seems to use (4x4)-Matricies and "skip" the variable that is not part of the section ... 

%even easier: only one GP=id
GP=eye(4);

% and also 5 Glocal Passages (because cycle ends with a GP)Start with all "id"
% later, the more complicated matricies are entered here
%GP(1)=eye(4);
%GP(2)=eye(4);
%GP(3)=eye(4);
%GP(4)=eye(4);
%GP(5)=eye(4);
%GP(6)=eye(4);

%digits(50);
%sym u; % use 50 digits for symbolic computations

%%%%%%%%%% Here are the parameters that determine which Cycle/Passages are tested %%%%%%%%%%%%%%%%%%%%%%%%%%

% the critical part of the "classical/standard" 18-cycle 
% , i.e. sectors (4)-2-5-4-3-4, i.e. 5 Local and Global Passages, starting with a GP from sector 4 to sector 3. 

% we nevertheless have to save the data for 6 Local passages, because our input will be the out-values in sector 4 before the GP 
MaxLoc=6;
%MaxLoc=4; % in order to test step by step, first start with Passage B2 alone...

%u=1.1881943016134132183116889409522109988848477157625; % u=[1,5,3,5,3,...], in otder to test B2-A, i.e. (4)-2-5-4-3-4

% Sector [loc]: Save the sector we are in at Passage "loc" 
%Sector = [4 2 5 4 3 4];
%Sector = [4 2 5 4];

% Outgoing[loc]: Which cap are we taking *after* Local Passage "loc" 
%Outgoing = [3 2 1 3 2 3];
%Outgoing = [3 2 1 3];

%%%%% Other Cycles/Passages:

%u=[3,5,3,5,...], in order to test Passage A, i.e. (4)-3-4
%u = 3.1881943016134132183116889409522109988848477157625 % 
%Outgoing = [3 2 3];
%Sector = [4 3 4]; 
%MaxLoc=3;

% u=[1,5,3,5,3,...], but now test B1-D, i.e. (4)-2-5-6-3-4
u=1.1881943016134132183116889409522109988848477157625; 
Sector = [4 2 5 6 3 4];
Outgoing = [3 2 3 1 2 3];
%MaxLoc=6;



%%%%%%%%%% END of the parameters that determine which Cycle/Passages are tested %%%%%%%%%%%%%%%%%%%%%%%%%%

% The Eigenvalues are computed in the file "ComputeEV.m"
% They are stored in the following array: EV[sector][k], where sector=1...6, k=1,2,3,4 and stands for the EV t,c,n,a, i.e. two,cross,n-minus,A 
% as EV is a global variable, it must be initialized in the main file
EV=zeros(6,4);

%EV=sym(ev,'d'); %symbolic

ComputeEV;
EV

% store values of variables in in/out-section before and after each local passage 
% syntax: x[loc][k][1/2], where in the last index "1" means "in" and "2" means "out" 
x=zeros(MaxLoc,4,2);

%x=sym(X,'d'); %symbolic


% We put our section *before* the curvature-transition from sector 4,
% i.e. we have to initialize the "out" value before the first global passage as out "inital value": x[1][k][out], i.e. x(1,k,2)

% also: the variable where we put the section transverse to (i.e. the transition variable) is equal to one, i.e. n-minus=1, i.e. x(1,3,2)=1
x(1,3,2)= 1;

% the other initial values
x(1,1,2)=0.0001;
x(1,2,2)=0.0001;
x(1,4,2)=0.0001;


% Make those variables global, i.e. not local for the for-loops 
loc=1; % the number of the local passage 
k=1;    % an index 1...4 for the current variable we are computing (t,c,n,a) (see above) 

% be careful: remember that we have chosen a section always *before* the curvature transition, i.e. *after* the last LP in sector 4 (that's why we start with a GP, *not* with LP)

for loc=1:MaxLoc
    loc
    u
    
    % Local Passage %
    
    % skip the *first* LP, as we start with a GP (but still need the data-structures for the first LP)
    % this is a little stupid,but as we index out data by the number of the local passage loc, it seems the easiest quick&dirty solution
    if loc==1 
        %skip first LP, i.e. do nothing here and directly jump to GP
    else
    
        for k=1:4
            
            if k==Outgoing(loc) % we put our section to (cap-variable)==1
                x(loc,k,2)=1;
                continue;
            end
        
            %EV(Sector(loc),k)
            %EV(Sector(loc),Outgoing(loc))
            %(-EV(Sector(loc),k)/EV(Sector(loc),Outgoing(loc)))
            
            %x(loc,Outgoing(loc),1)
                       
            x(loc,k,2) = (x(loc,Outgoing(loc),1))^(-EV(Sector(loc),k)/EV(Sector(loc),Outgoing(loc)))*x(loc,k,1);
            %x(loc,k,2)
            
            
        end
    end
    
    % Global Passage
    
    % skip the *last* GP, as we end with a LP 
    if loc==MaxLoc continue; end
    
    
    %First adjust u depending if we do a frame/curvature transition
    
    if Outgoing(loc)==3 %if curvatue transition then apply Kasner map, if not, then u is unchanged (Frame transition)
        if u<2
            u=1/(u-1);
        else
            u=u-1;
        end
        ComputeEV; % Re-Compute the EV for the new value of u
        EV
    end
    
    
    % Global Passage %
    for k=1:4
        if k==Outgoing(loc)
            x(loc+1,k,1)=1;  % we put our section to (cap-variable)==1
            continue;
        end
        
        % as GP is id anyway, start with this
        x(loc+1,k,1)=x(loc,k,2);
        
        %x(loc+1,k,1)=(GP(k,1)*x(loc,1,2))+(GP(k,2)*x(loc,2,2))+(GP(k,3)*x(loc,3,2))+(GP(k,4)*x(loc,4,2));
        
    end
        
end

log(x(1,:,2))  % the input we gave
log(x(MaxLoc,:,2)) % the result we get

%If[k===Outgoing[loc],Continue[],   (* the outgoing variable is not part of the sections. IDEA: maybe mark that entry somehow, e.g. by a BIG number *)
%Print[k," ",Outgoing[loc]]
% x[loc][k][2]= ((x[loc][Outgoing[loc]][1])^(-EV[Sector[loc]][k]/EV[Sector[loc]][Outgoing[loc]])) * x[loc][k][1]; *)


% Global Passage 
% PROBLEM: How to cope with fact that GP is a 3x3 Matrix, but we have 4 variables ??? Maybe the easiest is to enter it as 4x4 matricies, then i don't have to change anything here, probably... *)
% x[loc+1][k][1]=(GP[loc][k][1]*x[loc][1][2])+ (GP[loc][k][2]*x[loc][2][2])+(GP[loc][k][3]*x[loc][3][2])+(GP[loc][k][4]*x[loc][4][2]); *)

