% Compute the array of Eigenvalue, for the current value of u (that must be a global variable)

% Because the formulas for the EValues depend on the sector, compute them for each one seperately 
% Store them in the following array: EV[sector][k], where sector=1...6, k=1,2,3,4 and stands for the EV t,c,n,a, i.e. two,cross,n-minus,A 

% as EV is a global variable, it must be initialized in the main file
%EV=zeros(6,4);


% Sector  2 bzw.(213)

% compute kasner exponents (this depends on sector)
p2=-u/(1+u+u^2);
p1=(u+1)/(1+u+u^2);
% p3 is not used anyway

% compute sp, sm (the same in all sectors)
sp=-3/2*p1+1/2;
sm=-sqrt(3)/2*(p1+2*p2-1);

% store the EV in the array
EV(2,1)=-3*sp+sqrt(3)*sm; % two 
EV(2,2)=-2*sqrt(3)*sm;    % cross
EV(2,3)=2+2*sp+2*sqrt(3)*sm; % n-minus
EV(2,4)=2+2*sp; % A


% Sector  3 bzw.(231)

p2=-u/(1+u+u^2);
% p3 is not used anyway
p1=(u*(u+1))/(1+u+u^2);

sp=-3/2*p1+1/2;
sm=-sqrt(3)/2*(p1+2*p2-1);

EV(3,1)=-3*sp+sqrt(3)*sm;
EV(3,2)=-2*sqrt(3)*sm;
EV(3,3)=2+2*sp+2*sqrt(3)*sm;
EV(3,4)=2+2*sp;


% Sector  4 bzw.(321)

% p3 is not used anyway
p2=(u+1)/(1+u+u^2);
p1=(u*(u+1))/(1+u+u^2);

sp=-3/2*p1+1/2;
sm=-sqrt(3)/2*(p1+2*p2-1);

EV(4,1)=-3*sp+sqrt(3)*sm;
EV(4,2)=-2*sqrt(3)*sm;
EV(4,3)=2+2*sp+2*sqrt(3)*sm;
EV(4,4)=2+2*sp;



% Sector  5 bzw.(312)

% p3 is not used anyway
p1=(u+1)/(1+u+u^2);
p2=(u*(u+1))/(1+u+u^2);

sp=-3/2*p1+1/2;
sm=-sqrt(3)/2*(p1+2*p2-1);

EV(5,1)=-3*sp+sqrt(3)*sm;
EV(5,2)=-2*sqrt(3)*sm;
EV(5,3)=2+2*sp+2*sqrt(3)*sm;
EV(5,4)=2+2*sp;


% Sector  6 bzw.(132)

p1=-u/(1+u+u^2);
% p3 is not used anyway
p2=(u*(u+1))/(1+u+u^2);

sp=-3/2*p1+1/2;
sm=-sqrt(3)/2*(p1+2*p2-1);

EV(6,1)=-3*sp+sqrt(3)*sm;
EV(6,2)=-2*sqrt(3)*sm;
EV(6,3)=2+2*sp+2*sqrt(3)*sm;
EV(6,4)=2+2*sp;
