import numpy as np
import scipy as sp
from scipy.optimize import minimize
import matplotlib.pyplot as plt

phi_0 = 0.04
phi_1 = 0.0001

k_0 = 0.5
k_1 = 0.32
k_2 = 94
k_3 = -12

alpha = 0.0025
beta = 0.02
delta = 0.01
nu = 3

r = 0.03

N = 20
tau = 0.1

w_0 = 0.75
l_0 = 0.75
d_0 = 5
b_0 = 0



def phillips_curve(l):
    return phi_1/(1-l)**2-phi_0

def kappa(p):
    return k_0+k_1*np.arctan(k_2*p+k_3)

def mu(p):
    return kappa(p)/nu-delta

def f(w,l,d,b,g,tau):
    p = 1 - w - r*d + g
    w_n = w + tau*w*(phillips_curve(l)-alpha)
    l_n = l + tau*l*(mu(p) - alpha - beta)

    if(l_n>=0.999):
        l_n=0.999

    d_n = d + tau*(nu*mu(p)+nu*delta-p-d*mu(p))
    b_n = b + tau*(g+(r-mu(p))*b)
    return w_n, l_n,d_n, b_n

def solve_flow(w,l,d,b,g):
    for i in range(N):
        w,l,d,b = f(w,l,d,b,g[i],tau)
    return w,l,d,b

def solve_flow_array(w,l,d,b,g,m):
    w_a = []
    l_a = []
    d_a = []
    b_a = []
    w_a.append(w)
    l_a.append(l)
    d_a.append(d)
    b_a.append(b)

    for i in range(m):
        w,l,d,b = f(w,l,d,b,g[i % N],tau)
        w_a.append(w)
        l_a.append(l)
        d_a.append(d)
        b_a.append(b)

    return w_a,l_a,d_a,b_a

def min_function(g):
    w,l,d,b = solve_flow(w_0,l_0,d_0,b_0,g)
    return b
#
def constraint_function(g):
    w,l,d,b = solve_flow(w_0,l_0,d_0,b_0,g)
 #   print(g)
  #  print(w,l,d,b)
    return 0.001-(w-w_0)**2-(l-l_0)**2-(d-d_0)**2

bounds = [[-100,100] for i in range(N)]

res = minimize(lambda x: min_function(x), [0]*N,constraints=[{'type': 'ineq', 'fun': lambda x: 0.97-x[1]}, {'type': 'ineq', 'fun': constraint_function}],options={'maxiter': 5000, 'disp': True},
               bounds=bounds)

print(res)
print(solve_flow(w_0,l_0,d_0,b_0,res.x))

w_a,l_a,d_a,b_a = solve_flow_array(w_0,l_0,d_0,b_0,res.x,10*N)

print(d_a)

plt.figure()
plt.plot(l_a,w_a)

plt.figure()
plt.plot(d_a)
plt.title('debt')

plt.figure()
plt.plot(b_a)
plt.title('government')

plt.figure()
plt.plot(res.x)
plt.title('control')

plt.show()




