//	JOX - joes own chess system	
//
//
//  File MOVEGEN.CC contains move-generation routines for black and white !
//
//
// last modified: 17.8.99


#if !defined(CHECKMV_CC)
#define CHECKMV_CC

#include <global.h>

// amove contains the full move description of the move from from_nr to to_nr if
// that move is valid, i.e. if check_move returns 1 !
// if check_move returns 0, amove is not changed !


int check_move_w(move *amove,unsigned char from_nr,unsigned char to_nr)
{
 unsigned char rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 register long long from,to;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

 from = bit[from_nr];
 to = bit[to_nr];

 if ((from & ~board.w_occ) || (to & board.w_occ)) return 0;	// from must be w_occ (may not be ~w_occ !!)
								// to must be ~w_occ (may not be w_occ !!)

 switch (board.array64[from_nr])
 {


  case PAWN:


	// WHITE PAWNS (captures right)

	if ((from & NOT_RIGHT_EDGE << 9) & board.b_occ & to)
	{
			board.w_attacks |= from;
		        amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = PAWN;
			amove->det.ail.flags |= NORMAL_CAPTURE;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	// WHITE PAWNS (captures left)

	if ( ((from & NOT_LEFT_EDGE) << 7) & board.b_occ & to)
	{
			board.w_attacks |= from;
		        amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = PAWN;
			amove->det.ail.flags |= NORMAL_CAPTURE;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	// WHITE PAWNS (one step)

	pawn_fields_empty = (from << 8) & (~board.occ.ll);	// bitboard of empty fields in front of pawns

	if (pawn_fields_empty & to)
	{
			board.w_attacks |= from;
	 		amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = PAWN;
			amove->det.ail.flags = 0;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	// WHITE PAWNS (two steps)

	if (((pawn_fields_empty & RANK_3) << 8) & (~board.occ.ll) & to)
	{
			board.w_attacks |= from;
		        amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = PAWN;
			amove->det.ail.flags = 0 | PAWN_TWO_STEPS;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	break;
 	
  case KNIGHT:

		// WHITE KNIGHT

		if (knight_moves[from_nr] & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = KNIGHT;
                        if (board.b_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
		};	

                break;

  case ROOK:

		// WHITE ROOK

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		if ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = ROOK;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.b_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

		break;

  case BISHOP:

		// WHITE BISHOP

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		if ((a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = BISHOP;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.b_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

                break;

  case QUEEN:
		
		// WHITE QUEEN

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		if ( (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern] | a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = QUEEN;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.b_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

                break;

  case KING:

		// WHITE KING

                if (king_moves[from_nr] & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = KING;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.b_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	
		
		break;

  default: 	return 0;

 };
 return 0;
}



int check_move_b(move *amove,unsigned char from_nr,unsigned char to_nr)
{
 unsigned char rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 register long long from,to;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

 from = bit[from_nr];
 to = bit[to_nr];

 switch (board.array64[from_nr])
 {


 case -PAWN:


	// BLACK PAWNS (captures right)

	if ((from & NOT_RIGHT_EDGE >> 7) & board.w_occ & to)
	{
			board.w_attacks |= from;
		        amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -PAWN;
			amove->det.ail.flags |= NORMAL_CAPTURE;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	// BLACK PAWNS (captures left)

	if ( ((from & NOT_LEFT_EDGE) >> 9) & board.w_occ & to)
	{
			board.w_attacks |= from;
		        amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -PAWN;
			amove->det.ail.flags |= NORMAL_CAPTURE;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	// BLACK PAWNS (one step)

	pawn_fields_empty = (from >> 8) & (~board.occ.ll);	// bitboard of empty fields in front of pawns

	if (pawn_fields_empty & to)
	{
			board.w_attacks |= from;
	 		amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -PAWN;
			amove->det.ail.flags = 0;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	// BLACK PAWNS (two steps)

	if (((pawn_fields_empty & RANK_6) >> 8) & (~board.occ.ll) & to)
	{
			board.w_attacks |= from;
		        amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -PAWN;
			amove->det.ail.flags = 0 | PAWN_TWO_STEPS;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
			return 1;
	};

	break;
 	
  case -KNIGHT:

		// BLACK KNIGHT

		if (knight_moves[from_nr] & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -KNIGHT;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.w_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

                break;

  case -ROOK:

		// BLACK ROOK

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		if ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -ROOK;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.w_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

		break;

  case -BISHOP:

		// BLACK BISHOP

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		if ((a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -BISHOP;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.w_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

                break;

  case -QUEEN:
		
		// BLACK QUEEN

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		if ( (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern] | a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern])  & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -QUEEN;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.w_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	

                break;

  case -KING:

		// BLACK KING

                if (king_moves[from_nr] & to)
		{
			board.w_attacks |= from;
			amove->from = from;
			amove->to = to;			
                        amove->det.ll = 0;
			amove->det.ail.piece = -KING;
			amove->det.ail.from_nr = from_nr;
			amove->det.ail.flags |= FROM_NR_COMPUTED;
			amove->det.ail.to_nr = to_nr;
			amove->det.ail.flags |= TO_NR_COMPUTED;
                        if (board.w_occ & to) amove->det.ail.flags |= NORMAL_CAPTURE;
			return 1;
		};	
		
		break;

  default: 	return 0;

 };
 return 0;
}



#endif