//	JOX - joes own chess system	
//
//
//  File DATA.CC contains the data variables, the extern stuff is in global.h
//  Only include this file once !
//
// last modified: 17.8.99


#if !defined(UNMAKE_CC)
#define UNMAKE_C

#include <global.h>

// white to move ?

int wtm;

int solltiefe;
int piece_value[7] = { 0,100,300,300,500,900,10000 };

int user_colour;
int computer_colour;

// THE BOARD

position board;

// contains the game tree

TREE tree;

// arrays to convert rotated square to 64er square (referring to square numbers !)
// initialized in init_data !

int l90_to_normal[64];
int a1h8_to_normal[64];
int a8h1_to_normal[64];


// returns bitboard with the bits of the corresponding rank/file set
// initialized in init_data !

unsigned long long  rank[8];       // be careful: rank[0] = RANK_1, rank[1] = RANK_2 etc !!!
unsigned long long file[8];       // file[0] = FILE_A etc.


// bit[n] is a bitboard where only bit n is set
// n has a range of 0-63, it starts at 0 just like an array !!!	

long long bit[64];

long long bit_l90[64];
long long bit_a1h8[64];
long long bit_a8h1[64];

// bitnr returns the number of the LSB of an 16-bit value
// if no bit is set: bitnr[0] = -1 !!!
// index is a 16 bit value -> 4 table-lookups for a Bitboard (-> function getbitnr(b))

char bitnr[1024 * 64];


// the bitboards in the following arrays  contain both captures and
// non-captures, but also captures of the own colour, thats why you
// have to AND them with the complement of your own pieces. AND them
// with the opponents pieces to produce only captures.

long long rank_moves[64][256];   // rank_moves[field][rank_pattern]
long long file_moves[64][256];   // rank_moves[field][file_pattern]

long long a1h8_moves[64][256];   // a1h8_moves[field][a1h8_pattern]
long long a8h1_moves[64][256];   // a8h1_moves[field][a8h1_pattern]

// ever possible moves for knight and king

long long knight_moves[64];
long long king_moves[64];

char ausgangs[120]= { 100,100,100,100,100,100,100,100,100,100,      \
			  100,100,100,100,100,100,100,100,100,100,  \
			  100,4   ,2   ,3   ,5   ,6   ,3   ,2   ,4   ,100,  \
			  100,1   ,1   ,1   ,1   ,1   ,1   ,1   ,1   ,100,  \
			  100,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,100,  \
			  100,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,100,  \
			  100,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,100,  \
			  100,0   ,0   ,0   ,0   ,0   ,0   ,0   ,0   ,100,  \
			  100,-1  ,-1  ,-1  ,-1  ,-1  ,-1 ,-1   ,-1  ,100,  \
			  100,-4  ,-2  ,-3  ,-5  ,-6  ,-3  ,-2  ,-4  ,100,  \
			  100,100,100,100,100,100,100,100,100,100,  \
			  100,100,100,100,100,100,100,100,100,100 };

long long already_generated[MAX_PLY][64];

#endif
