//	JOX - joes own chess system	
//
//
//  File GLOBAL.H contains all global
//
//	- definitions (e.g. #defines, typedefs)
//	- data (e.g extern int rook_moves)
//	- functions prototypes
// and is included in every source module.
//
// last modified: 17.8.99


#if !defined(GLOBAL_H)

#define GLOBAL_H


// retuns a bitboard with only the LSB of b set

#define GET_LSB(b) ((b) & (-b))


// clears the LSB of bitboard b

#define CLEAR_LSB(b) ((b) &= ((b) -1))


// FLAGS in struct position:
// be careful: assign each bit only once !!!

#define MAY_WHITE_CASTLE 	3
#define MAY_WHITE_CASTLE_SHORT 	1
#define MAY_WHITE_CASTLE_LONG  	2


#define MAY_BLACK_CASTLE       12
#define MAY_BLACK_CASTLE_SHORT	4
#define MAY_BLACK_CASTLE_LONG  	8

// FLAGS in move
// be careful: assign each bit only once !!!

#define FROM_NR_COMPUTED		 1      	// has the number of the from-square already been computed by movegen ?
#define TO_NR_COMPUTED			 2		// has the number of the to-square already been computed by movegen ?

#define SPECIAL_MOVE		       252	        // a move is a SPECIAL_MOVE if one of the following bits is set !

#define PAWN_TWO_STEPS			 4
#define NORMAL_CAPTURE			 8
#define PROMOTE				16
#define PROMOTE_AND_CAPTURE		32
#define CASTLE				64
#define EN_PASSENT		       128	

// MISC 64-bit bitboards

#define RANK_1 0x00000000000000FF
#define RANK_2 0x000000000000FF00
#define RANK_3 0x0000000000FF0000
#define RANK_4 0x00000000FF000000
#define RANK_5 0x000000FF00000000
#define RANK_6 0x0000FF0000000000
#define RANK_7 0x00FF000000000000
#define RANK_8 0xFF00000000000000

#define FILE_A 0x0101010101010101
#define FILE_B 0x0202020202020202
#define FILE_C 0x0404040404040404
#define FILE_D 0x0808080808080808
#define FILE_E 0x1010101010101010
#define FILE_F 0x2020202020202020
#define FILE_G 0x4040404040404040
#define FILE_H 0x8080808080808080

#define NOT_LEFT_EDGE  0xFEFEFEFEFEFEFEFE
#define NOT_RIGHT_EDGE 0x7F7F7F7F7F7F7F7F

#define MAX_PLY 32   	
#define MAX_MOVES 128	
#define WHITE 0
#define BLACK 1

typedef struct
{
 char from_nr;  // also set by make_move, not only by movegen !
 char to_nr;	// only set by make_move and check_move, not by movegen !
 char piece;
 char flags;
// the following variables are set by make_move, not by movegen !
 char captured;		
 char promoted;
 short score;
} move_description;

typedef union
{
 long long ll;
 move_description ail;
} union_move_description;

typedef struct
{
 long long from;
 long long to;
 union_move_description det;
} move;

typedef union
{
 long long ll;
 unsigned char byte[8];
} rotated;

typedef struct
{
 long long w_occ;
 long long b_occ;

 rotated occ;
 rotated occ_l90;
 rotated occ_a1h8;
 rotated occ_a8h1;

 long long pawns;
 long long knights;
 long long bishops;
 long long rooks;
 long long queens;
 long long kings;

 // array to have fast access to the pieces positions, but dont care about the pawns here !

 char w_figpos[7][2];	// the white knights position can be found at w_figpos[KNIGHT][0] and at w_figpos[KNIGHT][1] etc. !!!
 char b_figpos[7][2];   // if a piece has been captured, the value is set to a value < 0 (i.e. -to_nr, but reffer to make_move !)

 long long w_attacks;	// be careful: only use when sure that the correct bits are set !!!
 long long b_attacks;   // be careful: only use when sure that the correct bits are set !!!

 char array64[64];
 long flags;
} position;

typedef struct
{
 move mvs[MAX_PLY][MAX_MOVES];
 int matbilanz;
} TREE;

typedef enum { A1,B1,C1,D1,E1,F1,G1,H1,
               A2,B2,C2,D2,E2,F2,G2,H2,
               A3,B3,C3,D3,E3,F3,G3,H3,
               A4,B4,C4,D4,E4,F4,G4,H4,
               A5,B5,C5,D5,E5,F5,G5,H5,
               A6,B6,C6,D6,E6,F6,G6,H6,
               A7,B7,C7,D7,E7,F7,G7,H7,
               A8,B8,C8,D8,E8,F8,G8,H8,
               BAD_SQUARE } SQUARES;

typedef enum {NONE=0, 	PAWN=1, KNIGHT=2,BISHOP=3,
               ROOK=4, QUEEN=5, KING=6} PIECES;




//----------------------------------------------------------------------------------------------------
//					DATA DEFINITIONS
//----------------------------------------------------------------------------------------------------


// THE BOARD

extern position board;

// contains the game tree

extern TREE tree;

// white to move ?

extern int wtm;
extern int solltiefe;
extern int piece_value[7];

extern int user_colour;
extern int computer_colour;

// arrays to convert rotated square to 64er square (referring to square numbers !)
// initialized in init_data !

extern int l90_to_normal[64];
extern int a1h8_to_normal[64];
extern int a8h1_to_normal[64];


// returns bitboard with the bits of the corresponding rank/file set
// initialized in init_data !

extern unsigned long long  rank[8];       // be careful: rank[0] = RANK_1, rank[1] = RANK_2 etc !!!
extern unsigned long long file[8];       // file[0] = FILE_A etc.


// bit[n] is a bitboard where only bit n is set
// n has a range of 0-63, it starts at 0 just like an array !!!	

extern long long bit[64];

extern long long bit_l90[64];
extern long long bit_a1h8[64];
extern long long bit_a8h1[64];

// bitnr returns the number of the LSB of an 16-bit value
// if no bit is set: bitnr[0] = -1 !!!
// index is a 16 bit value -> 4 table-lookups for a Bitboard (-> function getbitnr(b))

extern char bitnr[1024 * 64];

// the following array is used to determine if a move has already been generated
// e.g. if it is hash move or a killer move, if so, it may not be generated a
// second time by movegen !!!

// the index represents the from-square, i.e already_generated[23] contains
// 1 at all squares to which moves from field 23 have already been generated !

extern long long already_generated[MAX_PLY][64];

// the bitboards in the following arrays  contain both captures and non-captures, but also captures
// of the own colour (i.e the bit of the first occupied square e.g. on a file is also set !),
// thats why you have to AND them with the complement of your own pieces.
// AND them with the opponents pieces to produce only captures !

extern long long rank_moves[64][256];   // rank_moves[field][rank_pattern]
extern long long file_moves[64][256];   // rank_moves[field][file_pattern]

extern long long a1h8_moves[64][256];   // a1h8_moves[field][a1h8_pattern]
extern long long a8h1_moves[64][256];   // a8h1_moves[field][a8h1_pattern]

// ever possible moves for knight and king

extern long long knight_moves[64];
extern long long king_moves[64];

const char snspalte[9] = { 0,'a','b','c','d','e','f','g','h' };
extern char ausgangs[];

//----------------------------------------------------------------------------------------------------
//					FUNCTION PROTOTYPES
//----------------------------------------------------------------------------------------------------


// util.cc

extern char get_LSB_nr(long long b);	
extern int display_board_bitboards();
extern int get64(int p120);
extern int get120(int p64);
extern position convert_120_bb(char *p120);
extern int display_board();
extern void feldsn(char feld, char * sn);
extern int get_move(char *input_buffer,move *mv,int wtm);
extern int check_move(int from, int to, move* mv);

// init.cc

extern void init_bishop_moves();
extern void init_rook_moves();
extern void init_king_moves();
extern void init_knight_moves();
extern void init_bitnr_all();
extern void init_data();
extern void init_bits();

// movegen.cc

extern int movegen_w(move *movelist,long long from_squares,long long to_squares);
extern int movegen_b(move *movelist,long long from_squares,long long to_squares);

extern int generate_winning_captures_w(move *movelist, int ply);
extern int generate_winning_captures_b(move *movelist, int ply);

extern int generate_remaining_w(move *movelist, int ply);
extern int generate_remaining_b(move *movelist, int ply);

// checkmv.cc

extern int check_move_w(move *amove,unsigned char from_nr,unsigned char to_nr);
extern int check_move_b(move *amove,unsigned char from_nr,unsigned char to_nr);

// make.cc

extern int make_move_w(move *amove);
extern int make_move_b(move *amove);

// unmake.cc

extern int undo_move_w(move *amove);
extern int undo_move_b(move *amove);

// search.cc

extern int alpha_beta(int alpha, int beta, int sollply, int ply);
extern int root_search(int sollply);
extern int minimax(int sollply, int ply);
extern int root_minimax(int sollply);

#endif  // GLOBAL_H already definded ?