//	JOX - joes own chess system	
//
//
//  File INIT.CC contains all initialisation routines
//
//
// last modified: 17.8.99


#if !defined(INIT_CC)
#define INIT_CC

#include <global.h>

#define RAND 100

struct zug
{
  char neufeld; // Feld, auf das gezogen wird
  char altfeld; // Feld, auf dem die Figur stand
  char alt;     // alter Wert von neufeld
  char neu;     // neuer Wert von neufeld ( Figur, die zieht)
  char special; // k bei Rochade
  int val;
};
extern void zuggenerator(char * stellung,int farbe,int* listenlaenge,zug *zugliste);

extern char ausgangs[120];
// arrays to convert 64er square to rotated square (referring to square numbers !)
int normal_to_l90[64] = {
			A1,A2,A3,A4,A5,A6,A7,A8,
			B1,B2,B3,B4,B5,B6,B7,B8,
			C1,C2,C3,C4,C5,C6,C7,C8,
			D1,D2,D3,D4,D5,D6,D7,D8,
			E1,E2,E3,E4,E5,E6,E7,E8,
			F1,F2,F3,F4,F5,F6,F7,F8,
			G1,G2,G3,G4,G5,G6,G7,G8,
			H1,H2,H3,H4,H5,H6,H7,H8,
};

int normal_to_a1h8[64] = {
			A1,B2,C3,D4,E5,F6,G7,H8,
			A2,B3,C4,D5,E6,F7,G8,H1,
			A3,B4,C5,D6,E7,F8,G1,H2,
			A4,B5,C6,D7,E8,F1,G2,H3,
			A5,B6,C7,D8,E1,F2,G3,H4,
			A6,B7,C8,D1,E2,F3,G4,H5,
			A7,B8,C1,D2,E3,F4,G5,H6,
			A8,B1,C2,D3,E4,F5,G6,H7	
};		

int normal_to_a8h1[64] = {
			A8,B7,C6,D5,E4,F3,G2,H1,
			A7,B6,C5,D4,E3,F2,G1,H8,
			A6,B5,C4,D3,E2,F1,G8,H7,
			A5,B4,C3,D2,E1,F8,G7,H6,
			A4,B3,C2,D1,E8,F7,G6,H5,
			A3,B2,C1,D8,E7,F6,G5,H4,
			A2,B1,C8,D7,E6,F5,G4,H3,
			A1,B8,C7,D6,E5,F4,G3,H2
};


void init_data()
{
 	 for (int square = 0;square <64; square++)
	 {
		l90_to_normal[normal_to_l90[square]] = square;
		a1h8_to_normal[normal_to_a1h8[square]] = square;
		a8h1_to_normal[normal_to_a8h1[square]] = square;
	 };

         rank[0] = RANK_1;
         rank[1] = RANK_2;
         rank[2] = RANK_3;
         rank[3] = RANK_4;
         rank[4] = RANK_5;
         rank[5] = RANK_6;
         rank[6] = RANK_7;
         rank[7] = RANK_8;

         file[0] = FILE_A;
         file[1] = FILE_B;
         file[2] = FILE_C;
         file[3] = FILE_D;
         file[4] = FILE_E;
         file[5] = FILE_F;
         file[6] = FILE_G;
         file[7] = FILE_H;

	 tree.matbilanz = 0;

	 for(int ply = 0; ply < MAX_PLY; ply++)
	 	for (int i = 0; i<64; i++) already_generated[ply][i] = 0;
}




void init_bits()		// init the bit[] arrays
{
 long long b=1;
 for (int i=0; i<64; i++) bit[i]=0;
 for (int i=0; i<64; i++)
 {
	bit[i] = b;
	b = b << 1;
 };

 for (int i=0; i<64; i++)
 {
 	bit_l90[i] = bit[l90_to_normal[i]];
 	bit_a1h8[i] = bit[a1h8_to_normal[i]];
 	bit_a8h1[i] = bit[a8h1_to_normal[i]];
 };
}



/*void init_bitnr()
{
 long l=1;
 int i=0;
 for(; i < 16; l=l<<1,i++)
 {
  	bitnr[l] = i;
 };
} */


	
void init_bitnr_all() 	// init the bitnr[] array
{
 long i,ii,bitmask;;
 for(i=0;i < (1024 * 64);i++)
 {
	for (bitmask = 1,ii=0; ii < 16; ii++,bitmask = bitmask << 1)
	{
		if  (i & bitmask)
			{ bitnr[i] = ii; break; };
	};
 };
 bitnr[0] = -1;
}

void init_knight_moves()
{
 int key,l,x,feld;
 char brett[120];
 zug zugliste[128];
 for (int i =0;i<120;i++) brett[i]=ausgangs[i];
 for (int i =0;i<120;i++)
  {
   if (brett[i] == RAND) continue;
   brett[i]=0;
  };

 l=3;
 for(feld=0;feld<64;feld++)
 {
	brett[get120(feld)] = KNIGHT;
		l=3;
		zuggenerator(brett,1,&l,zugliste);
		for(x=0;x<l;x++)
		{
		 knight_moves[feld] = knight_moves[feld] | bit[get64(zugliste[x].neufeld)];
		};
       	brett[get120(feld)] = 0;
 };
}

void init_king_moves()
{
 int key,l,x,feld;
 char brett[120];
 zug zugliste[128];
 for (int i =0;i<120;i++) brett[i]=ausgangs[i];
 for (int i =0;i<120;i++)
  {
   if (brett[i] == RAND) continue;
   brett[i]=0;
  };

 l=3;
 for(feld=0;feld<64;feld++)
 {
	brett[get120(feld)] = KING;
		l=3;
		zuggenerator(brett,1,&l,zugliste);
		for(x=0;x<l;x++)
		{
		 king_moves[feld] = king_moves[feld] | bit[get64(zugliste[x].neufeld)];
		};
       	brett[get120(feld)] = 0;
 };
}

void init_rook_moves()
{
 unsigned char square;
 int rank_pattern,file_pattern;
 char rank,file,i;

 for(square=0;square<64;square++)
 {
       	rank = square >> 3;
       	file = square & 7;
	for( rank_pattern = 0; rank_pattern < 256; rank_pattern++)
       	{	
		rank_moves[square][rank_pattern] = 0;
        	
		for (i = file-1; i >= 0; i--) 	// moves along the rank in direction to file a
	 	{
			rank_moves[square][rank_pattern] |= bit[ ((rank << 3) | i) ];           	
			if ( (rank_pattern & bit[i]) != 0) break;;
		};
	
	        for (i = file+1; i <= 7; i++) 	// moves along the rank in direction to file h
	 	{
			rank_moves[square][rank_pattern] |= bit[ ((rank << 3) | i) ];           	
			if ( (rank_pattern & bit[i]) != 0) break;;
		};
	};
	

	for( file_pattern = 0; file_pattern < 256; file_pattern++)
	{	
		file_moves[square][file_pattern] = 0;

	
		   for (i = rank-1; i >= 0; i--) 	// moves along the file in direction to rank 1
 		    {
			file_moves[square][file_pattern] |= bit[ ((i << 3) | file) ];           	
			if ( (file_pattern & bit[i]) != 0) break;;

		    };

		   for (i = rank+1; i <= 7; i++) 	// moves along the file in direction to rank 8
	 	    {
			file_moves[square][file_pattern] |= bit[ ((i << 3) | file) ];           	
			if ( (file_pattern & bit[i]) != 0) break;;

		    };
       };
 };

}

void init_bishop_moves()
{
 unsigned char square;
 char rank,file;
 char curr_rank,curr_file;				// current rank and file during the for - loop
 int a1h8_pattern,a8h1_pattern;

 for(square=0;square<64;square++)
 {
	rank = square >> 3;
	file = square & 7;

	for( a1h8_pattern = 0; a1h8_pattern < 256; a1h8_pattern++)
        {	
		a1h8_moves[square][a1h8_pattern] = 0;

	 	// moves parallel to the a1h8 diagonal in direction to a1
	            for ( curr_file=file-1,curr_rank=rank-1 ; (curr_file >= 0 && curr_rank >= 0) ; curr_file--,curr_rank--)
	 	    {
			a1h8_moves[square][a1h8_pattern] |= bit[ ((curr_rank << 3) | curr_file) ];           	
       			if ( (a1h8_pattern & bit[curr_file]) != 0) break;;
		    };
	
	 	// moves parallel to the a1h8 diagonal in direction to h8
	            for ( curr_file=file+1,curr_rank=rank+1 ; (curr_file <= 7 && curr_rank <= 7) ; curr_file++,curr_rank++)
	 	    {
			a1h8_moves[square][a1h8_pattern] |= bit[ ((curr_rank << 3) | curr_file) ];           	
			if ( (a1h8_pattern & bit[curr_file]) != 0) break;;        	
		    };
	};

   	
	for( a8h1_pattern = 0; a8h1_pattern < 256; a8h1_pattern++)
	{	
	
		    a8h1_moves[square][a8h1_pattern] = 0;


	 	// moves parallel to the a8h1 diagonal in direction to h1
	            for ( curr_file=file+1,curr_rank=rank-1 ; (curr_file <= 7 && curr_rank >= 0) ; curr_file++,curr_rank--)
	 	    {
			a8h1_moves[square][a8h1_pattern] |= bit[ ((curr_rank << 3) | curr_file) ];           	
			if ( (a8h1_pattern & bit[curr_file]) != 0) break;
		    };

	 	// moves parallel to the a8h1 diagonal in direction to a8
	            for ( curr_file=file-1,curr_rank=rank+1 ; (curr_file >= 0 && curr_rank <= 7) ; curr_file--,curr_rank++)
	 	    {
		 	a8h1_moves[square][a8h1_pattern] |= bit[ ((curr_rank << 3) | curr_file) ];           	
			if ( (a8h1_pattern & bit[curr_file]) != 0) break;
       		    };


       };
 };
}

#endif