//	JOX - joes own chess system	
//
//
//  File MOVEGEN.CC contains move-generation routines for black and white !
//
//
// last modified: 17.8.99


#if !defined(MOVEGEN_CC)
#define MOVEGEN_CC

#include <global.h>

int movegen_w(move *movelist,long long from_squares,long long to_squares)
{
 unsigned char from_nr=0,rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 int movenr=0;
 register long long from,to,froms,tos;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

// following two lines needed, e.g. because of the format of the rook_moves and bishop_moves tables !
// because of them its clear that movegen_w produces only (pseudo) legal moves for white

 from_squares &= board.w_occ;		// only white pieces allowed in movegen_w !
 to_squares &= (~board.w_occ);		// you cannot move to a square that is occupied by a piece of your own colour !


// WHITE PAWNS (captures right)
	tos = ( (board.pawns & NOT_RIGHT_EDGE & from_squares) << 9) & board.b_occ & to_squares; 	

	froms = tos >> 9;
	while (from = GET_LSB(froms))
	{
			board.w_attacks |= from;
		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// WHITE PAWNS (captures left)
	tos = ( (board.pawns & NOT_LEFT_EDGE & from_squares) << 7) & board.b_occ & to_squares;
	froms = tos >> 7;
	while (from = GET_LSB(froms))
	{
			board.w_attacks |= from;
		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// WHITE PAWNS (one step)
	pawn_fields_empty = ( (board.pawns & from_squares) << 8) & (~board.occ.ll);	// bitboard of empty fields in front of pawns
        tos = pawn_fields_empty & to_squares;
	froms = tos >> 8;		
	while (from = GET_LSB(froms))
	{
			board.w_attacks |= from;
	 		movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags = 0;
			movenr++;
			CLEAR_LSB(tos);
	                CLEAR_LSB(froms);
	};

// WHITE PAWNS (two steps)
	tos = ( (pawn_fields_empty & RANK_3) << 8) & (~board.occ.ll);			// empty fields in front of pawns, the empty fields must be on
											// RANK_3 because the pawns have to on RANK_2 to move two steps !!
	froms = tos >> 16;
	while (from = GET_LSB(froms))
	{
			board.w_attacks |= from;
		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags = 0 | PAWN_TWO_STEPS;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};


// WHITE KNIGHT
	froms = board.knights & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		tos = knight_moves[from_nr] & to_squares;

		while (to = GET_LSB(tos))
		{
			board.w_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = KNIGHT;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


// WHITE ROOK
	froms = board.rooks & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			board.w_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = ROOK;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// WHITE BISHOP
	froms = board.bishops & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			board.w_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = BISHOP;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// WHITE QUEEN
	froms = board.queens & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = tos | ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares);

		while (to = GET_LSB(tos))
		{
			board.w_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = QUEEN;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};



// WHITE KING
	froms = board.kings & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);
		tos = king_moves[from_nr] & to_squares;
		while (to = GET_LSB(tos))
		{
			board.w_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = KING;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

/*

// CASTLES
	if (board.flags & MAY_WHITE_CASTLE)
	{
	 if (board.flags & MAY_WHITE_CA

*/


 return movenr;
}

int movegen_b(move *movelist,long long from_squares,long long to_squares)
{
 unsigned char from_nr=0,rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 int movenr=0;
 register long long from,to,froms,tos;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

// following two lines needed, e.g. because of the format of the rook_moves and bishop_moves tables !
// because of them its clear that movegen_w produces only (pseudo) legal moves for white

 from_squares &= board.b_occ;		// only white pieces allowed in movegen_w !
 to_squares &= (~board.b_occ);		// you cannot move to a square that is occupied by a piece of your own colour !


// BLACK PAWNS (captures right)
	tos = ( (board.pawns & NOT_RIGHT_EDGE & from_squares) >> 7) & board.w_occ & to_squares; 	

	froms = tos << 7;
	while (from = GET_LSB(froms))
	{
			board.b_attacks |= from;
		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// BLACK PAWNS (captures left)
	tos = ( (board.pawns & NOT_LEFT_EDGE & from_squares) >> 9) & board.w_occ & to_squares;
	froms = tos << 9;
	while (from = GET_LSB(froms))
	{
			board.b_attacks |= from;
		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// BLACK PAWNS (one step)
	pawn_fields_empty = ( (board.pawns & from_squares) >> 8) & (~board.occ.ll);	// bitboard of empty fields in front of pawns
        tos = pawn_fields_empty & to_squares;
	froms = tos << 8;		
	while (from = GET_LSB(froms))
	{
			board.b_attacks |= from;
	 		movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags = 0;
			movenr++;
			CLEAR_LSB(tos);
	                CLEAR_LSB(froms);
	};

// BLACK PAWNS (two steps)
	tos = ( (pawn_fields_empty & RANK_6) >> 8) & (~board.occ.ll);			// empty fields in front of pawns, the empty fields must be on
											// RANK_3 because the pawns have to on RANK_2 to move two steps !!
	froms = tos << 16;
	while (from = GET_LSB(froms))
	{
			board.b_attacks |= from;
		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags = 0 | PAWN_TWO_STEPS;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};


// BLACK KNIGHT
	froms = board.knights & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		tos = knight_moves[from_nr] & to_squares;

		while (to = GET_LSB(tos))
		{
			board.b_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -KNIGHT;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


// BLACK ROOK
	froms = board.rooks & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			board.b_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -ROOK;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// BLACK BISHOP
	froms = board.bishops & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			board.b_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -BISHOP;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// BLACK QUEEN
	froms = board.queens & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = tos | ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares);

		while (to = GET_LSB(tos))
		{
			board.b_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -QUEEN;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};



// BLACK KING
	froms = board.kings & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);
		tos = king_moves[from_nr] & to_squares;
		while (to = GET_LSB(tos))
		{
			board.b_attacks |= from;
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -KING;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

/*

// CASTLES
	if (board.flags & MAY_BLACK_CASTLE)
	{

*/


 return movenr;
}


int generate_winning_captures_w(move *movelist,int ply)
{
 unsigned char from_nr=0,rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 int movenr=0;
 register long long from,to,froms,tos;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

// following two lines needed, e.g. because of the format of the rook_moves and bishop_moves tables !
// because of them its clear that movegen_w produces only (pseudo) legal moves for white

 register long long from_squares = board.w_occ;
 register long long to_squares;


// WHITE PAWNS (captures right)
	tos = ( (board.pawns & NOT_RIGHT_EDGE & from_squares) << 9) & board.b_occ; 	

	froms = tos >> 9;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				continue; 				// skip noting it in the move list
			};		
		
		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr + 9;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			already_generated[ply][from_nr] |= to;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// WHITE PAWNS (captures left)
	tos = ( (board.pawns & NOT_LEFT_EDGE & from_squares) << 7) & board.b_occ;
	froms = tos >> 7;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				continue; 				// skip noting it in the move list
			};		
	
		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr + 7;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// WHITE KNIGHT
	
	to_squares = board.b_occ & ~board.pawns;
	
	froms = board.knights & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		tos = knight_moves[from_nr] & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = KNIGHT;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


// WHITE ROOK
	
	to_squares = board.b_occ & board.rooks & board.queens;
	
	froms = board.rooks & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = ROOK;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// WHITE BISHOP
	
	to_squares = board.b_occ & ~board.pawns;
	
	froms = board.bishops & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = BISHOP;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// WHITE QUEEN
	
	to_squares = board.b_occ & board.queens;
	
	froms = board.queens & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = tos | ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares);

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
		
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = QUEEN;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

 return movenr;
}

int generate_winning_captures_b(move *movelist,int ply)
{
 unsigned char from_nr=0,rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 int movenr=0;
 register long long from,to,froms,tos;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

// following two lines needed, e.g. because of the format of the rook_moves and bishop_moves tables !
// because of them its clear that movegen_w produces only (pseudo) legal moves for white

 register long long from_squares = board.b_occ;		// only white pieces allowed in movegen_w and v.v. !
 register long long to_squares;


// BLACK PAWNS (captures right)
	tos = ( (board.pawns & NOT_RIGHT_EDGE & from_squares) >> 7) & board.w_occ; 	

	froms = tos << 7;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr - 7;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// BLACK PAWNS (captures left)
	tos = ( (board.pawns & NOT_LEFT_EDGE & from_squares) >> 9) & board.w_occ;
	froms = tos << 9;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			

		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr - 9;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};



// BLACK KNIGHT
	
	to_squares = board.w_occ & ~board.pawns;
	
	froms = board.knights & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		tos = knight_moves[from_nr] & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -KNIGHT;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			already_generated[ply][from_nr] |= to;			
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


// BLACK ROOK
	
	to_squares = board.w_occ & board.rooks & board.queens;
	
	froms = board.rooks & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -ROOK;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// BLACK BISHOP
	
	to_squares = board.w_occ & ~board.pawns;
	
	froms = board.bishops & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -BISHOP;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// BLACK QUEEN
	
	to_squares = board.w_occ & board.queens;	
	
	froms = board.queens & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = tos | ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares);

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -QUEEN;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			already_generated[ply][from_nr] |= to;			
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

 return movenr;
}

int generate_remaining_w(move *movelist, int ply)
{
 unsigned char from_nr=0,rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 int movenr=0;
 register long long from,to,froms,tos;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

// following two lines needed, e.g. because of the format of the rook_moves and bishop_moves tables !
// because of them its clear that movegen_w produces only (pseudo) legal moves for white

 register long long from_squares = board.w_occ;
 register long long to_squares = ~board.w_occ;


// WHITE PAWNS (captures right)
	tos = ( (board.pawns & NOT_RIGHT_EDGE & from_squares) << 9) & board.b_occ; 	

	froms = tos >> 9;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
		
		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr + 9;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// WHITE PAWNS (captures left)
	tos = ( (board.pawns & NOT_LEFT_EDGE & from_squares) << 7) & board.b_occ;
	froms = tos >> 7;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
	
		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr + 7;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// WHITE PAWNS (one step)
	pawn_fields_empty = ( (board.pawns & from_squares) << 8) & (~board.occ.ll);	// bitboard of empty fields in front of pawns
        tos = pawn_fields_empty & to_squares;
	froms = tos >> 8;		
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
		
	 		movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags = 0;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr + 8;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
	                CLEAR_LSB(froms);
	};

// WHITE PAWNS (two steps)
	tos = ( (pawn_fields_empty & RANK_3) << 8) & (~board.occ.ll);			// empty fields in front of pawns, the empty fields must be on
											// RANK_3 because the pawns have to on RANK_2 to move two steps !!
	froms = tos >> 16;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

		        movelist[movenr].from = from;
			movelist[movenr].to = GET_LSB(tos);			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = PAWN;
			movelist[movenr].det.ail.flags = 0 | PAWN_TWO_STEPS;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr + 16;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};


// WHITE KNIGHT
	froms = board.knights & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		tos = knight_moves[from_nr] & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = KNIGHT;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


// WHITE ROOK
	froms = board.rooks & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = ROOK;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// WHITE BISHOP
	froms = board.bishops & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = BISHOP;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// WHITE QUEEN
	froms = board.queens & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = tos | ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares);

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
		
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = QUEEN;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};



// WHITE KING
	froms = board.kings & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);
		tos = king_moves[from_nr] & to_squares;
		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = KING;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.b_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


 return movenr;
}

int generate_remaining_b(move *movelist,int ply)
{
 unsigned char from_nr=0,rank_pattern,file_pattern,a1h8_pattern,a8h1_pattern;
 int movenr=0;
 register long long from,to,froms,tos;
 register long long pawn_fields_empty;		// bitboard of empty fields in front of pawns

// following two lines needed, e.g. because of the format of the rook_moves and bishop_moves tables !
// because of them its clear that movegen_w produces only (pseudo) legal moves for white

 register long long from_squares = board.b_occ;		// only white pieces allowed in movegen_w and v.v. !
 register long long to_squares = (~board.b_occ);	// you cannot move to a square that is occupied by a piece of your own colour !


// BLACK PAWNS (captures right)
	tos = ( (board.pawns & NOT_RIGHT_EDGE & from_squares) >> 7) & board.w_occ; 	

	froms = tos << 7;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr - 7;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// BLACK PAWNS (captures left)
	tos = ( (board.pawns & NOT_LEFT_EDGE & from_squares) >> 9) & board.w_occ;
	froms = tos << 9;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			

		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr - 9;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};

// BLACK PAWNS (one step)
	pawn_fields_empty = ( (board.pawns & from_squares) >> 8) & (~board.occ.ll);	// bitboard of empty fields in front of pawns
        tos = pawn_fields_empty & to_squares;
	froms = tos << 8;		
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			

	 		movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags = 0;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr - 8;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
	                CLEAR_LSB(froms);
	};

// BLACK PAWNS (two steps)
	tos = ( (pawn_fields_empty & RANK_6) >> 8) & (~board.occ.ll);			// empty fields in front of pawns, the empty fields must be on
											// RANK_3 because the pawns have to on RANK_2 to move two steps !!
	froms = tos << 16;
	while (from = GET_LSB(froms))
	{
			to = GET_LSB(tos);
			from_nr = get_LSB_nr(from);
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			

		        movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -PAWN;
			movelist[movenr].det.ail.flags = 0 | PAWN_TWO_STEPS;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
			movelist[movenr].det.ail.to_nr = from_nr - 16;
			movelist[movenr].det.ail.flags |= TO_NR_COMPUTED;
			movenr++;
			CLEAR_LSB(tos);
		        CLEAR_LSB(froms);
	};


// BLACK KNIGHT
	froms = board.knights & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		tos = knight_moves[from_nr] & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		
			
			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -KNIGHT;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};


// BLACK ROOK
	froms = board.rooks & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = (rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -ROOK;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// BLACK BISHOP
	froms = board.bishops & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -BISHOP;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

// BLACK QUEEN
	froms = board.queens & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);

		a1h8_pattern = board.occ_a1h8.byte[a1h8_to_normal[from_nr] >> 3];
		a8h1_pattern = board.occ_a8h1.byte[a8h1_to_normal[from_nr] >> 3];

		tos = (a1h8_moves[from_nr][a1h8_pattern] | a8h1_moves[from_nr][a8h1_pattern]) & to_squares;

		rank_pattern = board.occ.byte[from_nr >> 3];
		file_pattern = board.occ_l90.byte[l90_to_normal[from_nr] >> 3];

		tos = tos | ((rank_moves[from_nr][rank_pattern] | file_moves[from_nr][file_pattern]) & to_squares);

		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -QUEEN;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};



// BLACK KING
	froms = board.kings & from_squares;
	while (from = GET_LSB(froms))
	{
		from_nr = get_LSB_nr(from);
		tos = king_moves[from_nr] & to_squares;
		while (to = GET_LSB(tos))
		{
			if (already_generated[ply][from_nr] & to)	// if the move from from_nr to to has already been generated
			{
				already_generated[ply][from_nr] &= ~to; // clear it from already_generated[ply][from_nr]
				continue; 				// and skip noting it in the move list
			};		

			movelist[movenr].from = from;
			movelist[movenr].to = to;			
                        movelist[movenr].det.ll = 0;
			movelist[movenr].det.ail.piece = -KING;
			movelist[movenr].det.ail.from_nr = from_nr;
			movelist[movenr].det.ail.flags |= FROM_NR_COMPUTED;
                        if (board.w_occ & to) movelist[movenr].det.ail.flags |= NORMAL_CAPTURE;
			movenr++;
			CLEAR_LSB(tos);
		};	
	        CLEAR_LSB(froms);
	};

/*

// CASTLES
	if (board.flags & MAY_BLACK_CASTLE)
	{

*/


 return movenr;
}



#endif