#include <global.h>
#include <stdio.h>
#include <stdlib.h>

struct zug
{
  char neufeld; // Feld, auf das gezogen wird
  char altfeld; // Feld, auf dem die Figur stand
  char alt;     // alter Wert von neufeld
  char neu;     // neuer Wert von neufeld ( Figur, die zieht)
  char special; // k bei Rochade
  int val;
};

char boff[2]= { 10,20 };           // Offsets fuer die Zugberechnung
char boffs[2]= { 9,11 };
char soff[8]= { 21, 19, 8, 12, -21, -19, -8, -12 };
char koff[8]= { 10, 11, 1, -9, -10, -11, -1, 9   };
char loffor[7] = { 11, 22, 33, 44, 55, 66, 77};  // L oben rechts
char loffol[7] = { 9,18,27,36,45,54,63};
char loffur[7] = { -9,-18,-27,-36,-45,-54,-63};
char lofful[7] = { -11,-22,-33,-44,-55,-66,-77};
char toffr[7] = { 1,2,3,4,5,6,7};
char toffl[7] = { -1,-2,-3,-4,-5,-6,-7};
char toffo[7] = { 10,20,30,40,50,60,70};
char toffu[7] = { -10,-20,-30,-40,-50,-60,-70};
int wert[7] = { 0,100,300,300,500,900,10000 };

struct feldmoeglichkeiten
{
 unsigned char b : 2;   // 1 = WB darf 2 vor ;;  2 = SB darf 2 vor
 unsigned char lor : 3;
 unsigned char lol : 3;
 unsigned char lur : 3;
 unsigned char lul : 3;
 unsigned char tr : 3;
 unsigned char tl : 3;
 unsigned char to : 3;
 unsigned char tu : 3;
};

feldmoeglichkeiten fm[120];   // Nur 64 gebraucht, aber so gleiche Offsets !

#define RAND 100
const char weiss=1;
const char schwarz= -1;
const char MAX_ZUEGE=100;

char brett[120];

void init_fm()
{
 int x;
 for(x=21;x<92;x+=10)         // A1 - A8
  { fm[x].tr=7; fm[x].tl=0; fm[x].lol=0; fm[x].lul=0; };
 for(x=22;x<93;x+=10)         // B1 - B8
  { fm[x].tr=6; fm[x].tl=1; };
 for(x=23;x<94;x+=10)         // C1 - C8
  { fm[x].tr=5; fm[x].tl=2; };
 for(x=24;x<95;x+=10)         // D1 - D8
  { fm[x].tr=4; fm[x].tl=3; };
 for(x=25;x<96;x+=10)         // E1 - E8
  { fm[x].tr=3; fm[x].tl=4; };
 for(x=26;x<97;x+=10)         // F1 - F8
  { fm[x].tr=2; fm[x].tl=5; };
 for(x=27;x<98;x+=10)         // G1 - G8
  { fm[x].tr=1; fm[x].tl=6; };
 for(x=28;x<99;x+=10)         // H1 - H8
  { fm[x].tr=0; fm[x].tl=7; fm[x].lor=0; fm[x].lur=0; };

 for(x=21;x<29;x++)         // A1 - H1
  { fm[x].to=7; fm[x].tu=0; fm[x].b=0; fm[x].lur=0; fm[x].lul=0; };
 for(x=31;x<39;x++)         // A2 - H2
  { fm[x].to=6; fm[x].tu=1; fm[x].b=1;};
 for(x=41;x<49;x++)         // A3 - H3
  { fm[x].to=5; fm[x].tu=2; fm[x].b=0;};
 for(x=51;x<59;x++)         // A4 - H4
  { fm[x].to=4; fm[x].tu=3; fm[x].b=0;};
 for(x=61;x<69;x++)         // A5 - H5
  { fm[x].to=3; fm[x].tu=4; fm[x].b=0;};
 for(x=71;x<79;x++)         // A6 - H6
  { fm[x].to=2; fm[x].tu=5; fm[x].b=0;};
 for(x=81;x<89;x++)         // A7 - H7
  { fm[x].to=1; fm[x].tu=6; fm[x].b=1;};
 for(x=91;x<99;x++)         // A8 - H8
  { fm[x].to=0; fm[x].tu=7; fm[x].b=0; fm[x].lor=0; fm[x].lol=0; };

// Von unten nach oben ( lur/lul )

 for(x=31;x<=37;x++) fm[x].lur=1;
 for(x=32;x<=38;x++) fm[x].lul=1;

 for(x=41;x<=46;x++) fm[x].lur=2;
 for(x=43;x<=48;x++) fm[x].lul=2;

 for(x=51;x<=55;x++) fm[x].lur=3;
 for(x=54;x<=58;x++) fm[x].lul=3;

 for(x=61;x<=64;x++) fm[x].lur=4;
 for(x=65;x<=68;x++) fm[x].lul=4;

 for(x=71;x<=73;x++) fm[x].lur=5;
 for(x=76;x<=78;x++) fm[x].lul=5;

 for(x=81;x<=82;x++) fm[x].lur=6;
 for(x=87;x<=88;x++) fm[x].lul=6;

// Von oben nach unten ( lor/lol )

 for(x=81;x<=87;x++) fm[x].lor=1;
 for(x=82;x<=88;x++) fm[x].lol=1;

 for(x=71;x<=76;x++) fm[x].lor=2;
 for(x=73;x<=78;x++) fm[x].lol=2;

 for(x=61;x<=65;x++) fm[x].lor=3;
 for(x=64;x<=68;x++) fm[x].lol=3;

 for(x=51;x<=54;x++) fm[x].lor=4;
 for(x=55;x<=58;x++) fm[x].lol=4;

 for(x=41;x<=43;x++) fm[x].lor=5;
 for(x=46;x<=48;x++) fm[x].lol=5;

 for(x=31;x<=32;x++) fm[x].lor=6;
 for(x=37;x<=38;x++) fm[x].lol=6;

// Von rechts nach links ( lol/lul )

 for(x=22;x<=82;x+=10) fm[x].lol=1;
 for(x=32;x<=92;x+=10) fm[x].lul=1;

 for(x=23;x<=73;x+=10) fm[x].lol=2;
 for(x=43;x<=93;x+=10) fm[x].lul=2;

 for(x=24;x<=64;x+=10) fm[x].lol=3;
 for(x=54;x<=94;x+=10) fm[x].lul=3;

 for(x=25;x<=55;x+=10) fm[x].lol=4;
 for(x=65;x<=95;x+=10) fm[x].lul=4;

 for(x=26;x<=46;x+=10) fm[x].lol=5;
 for(x=76;x<=96;x+=10) fm[x].lul=5;

 for(x=27;x<=37;x+=10) fm[x].lol=6;
 for(x=87;x<=97;x+=10) fm[x].lul=6;

// Von links nach rechts ( lor/lur )

 for(x=27;x<=87;x+=10) fm[x].lor=1;
 for(x=37;x<=97;x+=10) fm[x].lur=1;

 for(x=26;x<=76;x+=10) fm[x].lor=2;
 for(x=46;x<=96;x+=10) fm[x].lur=2;

 for(x=25;x<=65;x+=10) fm[x].lor=3;
 for(x=55;x<=95;x+=10) fm[x].lur=3;

 for(x=24;x<=54;x+=10) fm[x].lor=4;
 for(x=64;x<=94;x+=10) fm[x].lur=4;

 for(x=23;x<=43;x+=10) fm[x].lor=5;
 for(x=73;x<=93;x+=10) fm[x].lur=5;

 for(x=22;x<=32;x+=10) fm[x].lor=6;
 for(x=82;x<=92;x+=10) fm[x].lur=6;

// Eckfelder

 fm[21].lor=7;
 fm[28].lol=7;
 fm[91].lur=7;
 fm[98].lul=7;

// for(x=0;x<120;x++) { if(brett[x]==RAND) continue;
// if(fm[x].lor==10) printf("%d LOR\n",x); if(fm[x].lol==10) printf("%dLOL\n",x);
// if(fm[x].lur==10) printf("%d LUR\n",x); if(fm[x].lul==10) printf("%d LUL\nx);};
}

void zuggenerator(char * stellung,int farbe,int* listenlaenge,zug *zugliste)
{
 int z=0,x,y=0,neu=0,b,l,alle;
 char neufeld;
 alle = 1;
// int neuwert;

 for(int c=21;c<=98;c++)
  {
   if(stellung[c]==RAND) continue;
   if(farbe==weiss)
	{
	 switch(stellung[c])
	  {
	   case 1: for (x=0;x <= fm[c].b;x++)
				{  if( (neufeld=stellung[c+boff[x]]) != 0) break;
				   if( (alle <= 0) ) break;
				   zugliste[z].neufeld= c+boff[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=1;
				   zugliste[z].special=0;
				   if(zugliste[z].neufeld > 90) // Umwandlung ?
					zugliste[z].special='u';
				   z++;
				};
			   for(x=0;x<2;x++)
				{
				 if ( (neufeld=stellung[c+boffs[x]]) < 0)
				  {
				   zugliste[z].neufeld= c+boffs[x];
				   zugliste[z].altfeld=c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=1;
				   zugliste[z].special=0;
				   z++;
				  };
				};
			   break;
	   case 2: for(x=0; x < 8;x++)
			   { if( (neufeld=stellung[c+soff[x]]) > 0) continue;
				 if( (alle <=0) && (neufeld == 0) ) continue;
				 zugliste[z].neufeld= c+soff[x];
				 zugliste[z].altfeld= c;
				 zugliste[z].alt=neufeld;
				 zugliste[z].neu=stellung[c];
				 zugliste[z].special=0;
				 z++;
			   };
			   break;
	   case 5:
	   case 3: for (x=0;x < fm[c].lor;x++)
				{  if( (neufeld=stellung[c+loffor[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+loffor[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   for (x=0;x < fm[c].lol;x++)
				{  if( (neufeld=stellung[c+loffol[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+loffol[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   for (x=0;x < fm[c].lur;x++)
				{  if( (neufeld=stellung[c+loffur[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+loffur[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   for (x=0;x < fm[c].lul;x++)
				{  if( (neufeld=stellung[c+lofful[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+lofful[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   if(stellung[c]==3) break;
	   //******************************
	   case 4: for (x=0;x < fm[c].to;x++)
				{  if( (neufeld=stellung[c+toffo[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffo[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   for (x=0;x < fm[c].tl;x++)
				{  if( (neufeld=stellung[c+toffl[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffl[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   for (x=0;x < fm[c].tu;x++)
				{  if( (neufeld=stellung[c+toffu[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffu[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   for (x=0;x < fm[c].tr;x++)
				{  if( (neufeld=stellung[c+toffr[x]]) > 0) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffr[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld < 0) break;
				};
			   break;
	   case 6: for(x=0; x < 8;x++)
				{ if( (neufeld=stellung[c+koff[x]]) > 0) continue;
				  if( (alle <=0) && (neufeld == 0) ) continue;
				  zugliste[z].neufeld= c+koff[x];
				  zugliste[z].altfeld= c;
				  zugliste[z].alt=neufeld;
				  zugliste[z].neu=stellung[c];
				  zugliste[z].special=0;
				  z++;
				};
				if( (c==25) && (stellung[28]==4) && (stellung[26]==0) && (stellung[27]==0) )
				{
				 zugliste[z].neufeld=27;
				 zugliste[z].altfeld=25;
				 zugliste[z].alt=0;
				 zugliste[z].neu=6;
				 zugliste[z].special='k';
				 z++;
				}
				if( (c==25) && (stellung[21]==4) && (stellung[24]==0) && (stellung[23]==0) && (stellung[22]==0) )
				{
				 zugliste[z].neufeld=23;
				 zugliste[z].altfeld=25;
				 zugliste[z].alt=0;
				 zugliste[z].neu=6;
				 zugliste[z].special='l';
				 z++;
				}
				break;
	  }; // Ende SWITCH (weiss)
	}
   else
	{
	 switch(stellung[c])
	  {
	   case -1: for ( x=0;x <= fm[c].b;x++)
				 {  if( (neufeld=stellung[c-boff[x]]) != 0) break;
					if( (alle <=0) )break;
					zugliste[z].neufeld= c-boff[x];
					zugliste[z].altfeld= c;
					zugliste[z].alt=neufeld;
					zugliste[z].neu=-1;
					zugliste[z].special=0;
				   if(zugliste[z].neufeld < 30) // Umwandlung ?
					zugliste[z].special='u';
					z++;
				 };
				for(x=0;x<2;x++)
				{
		 if ( (neufeld=stellung[c-boffs[x]]) > 0 && neufeld != RAND)
				  {
				   zugliste[z].neufeld= c-boffs[x];
				   zugliste[z].altfeld=c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=-1;
				   zugliste[z].special=0;
				   z++;
				  };
				};
			   break;
	   case -2: for(x=0; x < 8;x++)
			   { neufeld=stellung[c+soff[x]];
		 if(neufeld < 0 || neufeld == RAND) continue;
				 if( (alle <=0) && (neufeld == 0) ) continue;
				 zugliste[z].neufeld= c+soff[x];
				 zugliste[z].altfeld= c;
				 zugliste[z].alt=neufeld;
				 zugliste[z].neu=-2;
				 zugliste[z].special=0;
				 z++;
			   };
			   break;
	   case -5:
	   case -3: for (x=0;x < fm[c].lor;x++)
				{  neufeld=stellung[c+loffor[x]];
		   if( neufeld < 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+loffor[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   for (x=0;x < fm[c].lol;x++)
				{  neufeld=stellung[c+loffol[x]];
		   if( neufeld< 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+loffol[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   for (x=0;x < fm[c].lur;x++)
				{  neufeld=stellung[c+loffur[x]];
		   if( neufeld< 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+loffur[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   for (x=0;x < fm[c].lul;x++)
				{  neufeld=stellung[c+lofful[x]];
		   if( neufeld< 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+lofful[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   if(stellung[c]==-3) break;
	   //******************************
	   case -4: for (x=0;x < fm[c].to;x++)
				{  neufeld=stellung[c+toffo[x]];
		   if( neufeld< 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffo[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   for (x=0;x < fm[c].tl;x++)
				{  neufeld=stellung[c+toffl[x]];
		   if( neufeld< 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffl[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   for (x=0;x < fm[c].tu;x++)
				{  neufeld=stellung[c+toffu[x]];
		   if( neufeld < 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffu[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   for (x=0;x < fm[c].tr;x++)
				{  neufeld=stellung[c+toffr[x]];
		   if( neufeld < 0 || neufeld == RAND) break;
				   if( (alle <=0) && (neufeld == 0) ) continue;
				   zugliste[z].neufeld= c+toffr[x];
				   zugliste[z].altfeld= c;
				   zugliste[z].alt=neufeld;
				   zugliste[z].neu=stellung[c];
				   zugliste[z].special=0;
				   z++;
				   if (neufeld > 0) break;
				};
			   break;
	   case -6: for(x=0; x < 8;x++)
				{ neufeld=stellung[c+koff[x]];
		  if(neufeld < 0 || neufeld == RAND) continue;
				  if( (alle <=0) && (neufeld == 0) ) continue;
				  zugliste[z].neufeld= c+koff[x];
				  zugliste[z].altfeld= c;
				  zugliste[z].alt=neufeld;
				  zugliste[z].neu=stellung[c];
				  zugliste[z].special=0;
				  z++;
				};
				if( (c==95) && (stellung[98]==-4) && (stellung[96]==0) && (stellung[97]==0) )
				{
				 zugliste[z].neufeld=97;
				 zugliste[z].altfeld=95;
				 zugliste[z].alt=0;
				 zugliste[z].neu=-6;
				 zugliste[z].special='k';
				 z++;
				}
				if( (c==95) && (stellung[91]==-4) && (stellung[94]==0) && (stellung[93]==0) && (stellung[92]==0) )
				{
				 zugliste[z].neufeld=93;
				 zugliste[z].altfeld=95;
				 zugliste[z].alt=0;
				 zugliste[z].neu=-6;
				 zugliste[z].special='l';
				 z++;
				}
				break;

	  };// Ende SWITCH (schwarz)
	};  // Ende IF
  };    // Ende FOR
 *(listenlaenge)=z;
}



void printzugliste()
{
 int key,l,x,farbe;
 zug *zugliste= (zug*) malloc(MAX_ZUEGE*sizeof(zug));
 printf("\n\n");
 printf("Generator: S/W ?");
 key=getchar();
 if(key=='w')
 farbe = weiss;
 else farbe = schwarz;
 l=3;
 zuggenerator(brett,farbe,&l,zugliste);
 printf("***Zugliste***");
 for(x=0;x<l;x++)
 {
  if(x==25) getchar();
  printf("\nZug: %d  Altfeld: %d  Neufeld: %d Figur: %d Geschlagen: %d",x,zugliste[x].altfeld,zugliste[x].neufeld,zugliste[x].neu,zugliste[x].alt);
  brett[zugliste[x].neufeld]=-2;
 };
 printf("\n");
}

