//	JOX - joes own chess system	
//
//
//  File SEARCH.CC contains search routines
//
//
// last modified: 8.9.99


#if !defined(SEARCH_CC)
#define SEARCH_CC

#include <global.h>
#include <stdio.h>


int alpha_beta(int alpha, int beta, int sollply, int ply)
{
 int nr,value,best;
 move ml[200];
 int n = sollply - ply;

 if (wtm)
 {

        if ( (n < -5) || (ply >= MAX_PLY) ) return tree.matbilanz;
        if ( (n < 0) && (tree.matbilanz >= beta)) return tree.matbilanz;

	if (n < 0)
	{
		nr = movegen_w(tree.mvs[ply],board.w_occ,board.b_occ);
	} else	nr =  generate_winning_captures_w(tree.mvs[ply],ply);

        if (nr == 0) return tree.matbilanz;

        if (n < 0) best=tree.matbilanz; else best=-32000;

	for (int i = 0; i < nr; i++)
	{
		make_move_w(&tree.mvs[ply][i]);
		value = -alpha_beta(-beta,-alpha,sollply,ply+1);				
		undo_move_w(&tree.mvs[ply][i]);

		if (value > best)
		{
			best = value;
			if (value > beta)
			{
				if (n >= 0) for (int ii= 0; ii <= i; ii++) already_generated[ply][tree.mvs[ply][ii].det.ail.from_nr] = 0;				
				return value;
			};
		};

		if (value > alpha) alpha = value;
	};

	if (n < 0) return best;
		
	nr = generate_remaining_w(tree.mvs[ply],ply);
	
	for (int i = 0; i < nr; i++)
	{
		make_move_w(&tree.mvs[ply][i]);
		value = -alpha_beta(-beta,-alpha,sollply,ply+1);				
		undo_move_w(&tree.mvs[ply][i]);

		if (value > best)
		{
			best = value;
			if (value > beta)
			{
				if (n >= 0) for (int ii= 0; ii <= i; ii++) already_generated[ply][tree.mvs[ply][ii].det.ail.from_nr] = 0;				
				return value;
			};
		};
		if (value > alpha) alpha = value;
	};
	
	for (int ii= 0; ii < nr; ii++) already_generated[ply][tree.mvs[ply][ii].det.ail.from_nr] = 0;					
	return best;
 }
 else
 {

        if ( (n < -5) || (ply >= MAX_PLY) ) return -tree.matbilanz;
        if ( (n < 0) && (-tree.matbilanz >= beta)) return -tree.matbilanz;

	if (n < 0)
	{
		nr = movegen_b(tree.mvs[ply],board.b_occ,board.w_occ);		
	} else nr =  generate_winning_captures_b(tree.mvs[ply],ply);

        if (nr == 0) return -tree.matbilanz;

        if (n < 0) best=tree.matbilanz; else best=-32000;

	for (int i = 0; i < nr; i++)
	{
		make_move_b(&tree.mvs[ply][i]);
		value = -alpha_beta(-beta,-alpha,sollply,ply+1);				
		undo_move_b(&tree.mvs[ply][i]);

		if (value > best)
		{
			best = value;
			if (value > beta)
			{
				if (n >= 0) for (int ii= 0; ii <= i; ii++) already_generated[ply][tree.mvs[ply][ii].det.ail.from_nr] = 0;				
				return value;
			};
		};

		if (value > alpha) alpha = value;
	};

	if (n < 0) return best;
		
	nr = generate_remaining_b(tree.mvs[ply],ply);
	
	for (int i = 0; i < nr; i++)
	{
		make_move_b(&tree.mvs[ply][i]);
		value = -alpha_beta(-beta,-alpha,sollply,ply+1);				
		undo_move_b(&tree.mvs[ply][i]);

		if (value > best)
		{
			best = value;
			if (value > beta)
			{
				if (n >= 0) for (int ii= 0; ii <= i; ii++) already_generated[ply][tree.mvs[ply][ii].det.ail.from_nr] = 0;				
				return value;
			};
		};

		if (value > alpha) alpha = value;
	};
	
	for (int ii= 0; ii < nr; ii++) already_generated[ply][tree.mvs[ply][ii].det.ail.from_nr] = 0;						
	return best;
 };
}

int root_search(int sollply)
{
 int value,best,bestmove = 0,nr,alpha,beta,depth;	
 char from_sn[2],to_sn[2];
 move temp;

 for (depth = 2; depth <= sollply; depth++)
 {

        if (depth == 2)
	{
		alpha = -100000;
		beta =   100000;
	        best =  -100000;
	}
	else
	{
		alpha = best - 150;
		beta =  best + 150;
	        best =  -100000;
	};


        temp = tree.mvs[0][0];
	tree.mvs[0][0] = tree.mvs[0][bestmove];
        tree.mvs[0][bestmove] = temp;

        printf("\nTiefe = %d",depth);

	if (wtm)
	{

		 nr = generate_winning_captures_w(tree.mvs[0],0);

 		for (int i = 0; i < nr; i++)
		{
			make_move_w(&tree.mvs[0][i]);

                        feldsn(get120(tree.mvs[0][i].det.ail.from_nr),from_sn);
			feldsn(get120(tree.mvs[0][i].det.ail.to_nr),to_sn);
			printf("\nUntersuche Zug %d:  	%c%c %c%c",i,from_sn[0],from_sn[1],to_sn[0],to_sn[1]);

			value = -alpha_beta(-beta,-alpha,depth,1);				
			undo_move_w(&tree.mvs[0][i]);
	
			if (value > best) { best = value; bestmove = i; };
			if (value > alpha) alpha = value;
			
			printf("	Wert:	%d",value);

		};
		
		nr = generate_remaining_w(tree.mvs[0],0);

 		for (int i = 0; i < nr; i++)
		{
			make_move_w(&tree.mvs[0][i]);

                        feldsn(get120(tree.mvs[0][i].det.ail.from_nr),from_sn);
			feldsn(get120(tree.mvs[0][i].det.ail.to_nr),to_sn);
			printf("\nUntersuche Zug %d:  	%c%c %c%c",i,from_sn[0],from_sn[1],to_sn[0],to_sn[1]);

			value = -alpha_beta(-beta,-alpha,depth,1);				
			undo_move_w(&tree.mvs[0][i]);
	
			if (value > best) { best = value; bestmove = i; };
			if (value > alpha) alpha = value;
			
			printf("	Wert:	%d",value);

		};
                for (int i= 0; i< nr; i++) already_generated[0][tree.mvs[0][i].det.ail.from_nr] = 0;
			
	}
	else
	{

		nr =  generate_winning_captures_b(tree.mvs[0],0);

		for (int i = 0; i < nr; i++)
		{
			make_move_b(&tree.mvs[0][i]);

                        feldsn(get120(tree.mvs[0][i].det.ail.from_nr),from_sn);
			feldsn(get120(tree.mvs[0][i].det.ail.to_nr),to_sn);
			printf("\nUntersuche Zug %d:  	%c%c %c%c",i,from_sn[0],from_sn[1],to_sn[0],to_sn[1]);

			value = -alpha_beta(-beta,-alpha,depth,1);
			undo_move_b(&tree.mvs[0][i]);
        	
			if (value > best) { best = value; bestmove = i; };
			if (value > alpha) alpha = value;

			printf("	Wert:	%d",value);

		};
		
		nr =  generate_remaining_b(tree.mvs[0],0);

		for (int i = 0; i < nr; i++)
		{
			make_move_b(&tree.mvs[0][i]);

                        feldsn(get120(tree.mvs[0][i].det.ail.from_nr),from_sn);
			feldsn(get120(tree.mvs[0][i].det.ail.to_nr),to_sn);
			printf("\nUntersuche Zug %d:  	%c%c %c%c",i,from_sn[0],from_sn[1],to_sn[0],to_sn[1]);

			value = -alpha_beta(-beta,-alpha,depth,1);
			undo_move_b(&tree.mvs[0][i]);
        	
			if (value > best) { best = value; bestmove = i; };
			if (value > alpha) alpha = value;

			printf("	Wert:	%d",value);

		};
		
                for (int i= 0; i< nr; i++) already_generated[0][tree.mvs[0][i].det.ail.from_nr] = 0;		
	};
 };	
 return bestmove;
}

int minimax(int sollply, int ply)
{
 int nr,value,best=-1600;

 if (ply - sollply)
 {
	if (wtm) return tree.matbilanz; else return -tree.matbilanz;
 };

	if (wtm)
	{
		nr =  movegen_w(tree.mvs[ply],board.w_occ,~board.w_occ);	
		for (int i = 0; i < nr; i++)
		{
			make_move_w(&tree.mvs[ply][i]);
			value = -minimax(sollply,ply+1);				
			undo_move_w(&tree.mvs[ply][i]);	
			if (value > best) best = value;
		};
	}
	else
	{
		nr =  movegen_b(tree.mvs[ply],board.b_occ,~board.b_occ);
		for (int i = 0; i < nr; i++)
		{
			make_move_b(&tree.mvs[ply][i]);
			value = -minimax(sollply,ply+1);
			undo_move_b(&tree.mvs[ply][i]);
			if (value > best) best = value;      	
		};
	};
 return best;
}

int root_minimax(int sollply)
{
 int nr, value, best=-1600, bestmove;
 char from_sn[2],to_sn[2];

	if (wtm)
	{
		nr =  movegen_w(tree.mvs[0],board.w_occ,~board.w_occ);	
		for (int i = 0; i < nr; i++)
		{
			make_move_w(&tree.mvs[0][i]);
			value = -minimax(sollply,1);				
			undo_move_w(&tree.mvs[0][i]);	
			if (value > best) { best = value; bestmove = i; };
                        feldsn(get120(tree.mvs[0][i].det.ail.from_nr),from_sn);
			feldsn(get120(tree.mvs[0][i].det.ail.to_nr),to_sn);
			printf("\nUntersuche Zug %d:  	%c%c %c%c 	Figur: %d	Wert:	%d",i,from_sn[0],from_sn[1],to_sn[0],to_sn[1],tree.mvs[0][i].det.ail.piece,value);
//			display_board_bitboards();
		};
	}
	else
	{
		nr =  movegen_b(tree.mvs[0],board.b_occ,~board.b_occ);
		for (int i = 0; i < nr; i++)
		{
			make_move_b(&tree.mvs[0][i]);
			value = -minimax(sollply,1);
			undo_move_b(&tree.mvs[0][i]);
			if (value > best) { best = value; bestmove = i; };      	
                        feldsn(get120(tree.mvs[0][i].det.ail.from_nr),from_sn);
			feldsn(get120(tree.mvs[0][i].det.ail.to_nr),to_sn);
			printf("\nUntersuche Zug %d:  	%c%c %c%c 	Figur: %d	Wert:	%d",i,from_sn[0],from_sn[1],to_sn[0],to_sn[1],tree.mvs[0][i].det.ail.piece,value);
//			display_board_bitboards();
		};
	};
 return bestmove;
}

#endif