//	JOX - joes own chess system	
//
//
//  File UNMAKE.CC contains unmake_move routines for black and white
//
//
// last modified: 17.8.99


#if !defined(UNMAKE_CC)
#define UNMAKE_C

#include <global.h>
#include <stdio.h>

int undo_move_w(move *amove)
{
 register long long fromto = amove->from | amove->to;	

// set the from bit and clear the to bit in the bitboards in only one
// step by using XOR !

 board.w_occ ^= fromto;
 board.occ.ll ^= fromto;

 board.occ_l90.ll ^= ( bit_l90[amove->det.ail.from_nr] | bit_l90[amove->det.ail.to_nr] );
 board.occ_a1h8.ll ^= ( bit_a1h8[amove->det.ail.from_nr] | bit_a1h8[amove->det.ail.to_nr] );
 board.occ_a8h1.ll ^= ( bit_a8h1[amove->det.ail.from_nr] | bit_a8h1[amove->det.ail.to_nr] );

 switch(amove->det.ail.piece)
 {
 	case PAWN: 	
 			board.pawns ^= fromto;
			break;
 	case KNIGHT: 	
 			board.knights ^= fromto;
			if (board.w_figpos[KNIGHT][0] == amove->det.ail.to_nr) board.w_figpos[KNIGHT][0] = amove->det.ail.from_nr;
				else board.w_figpos[KNIGHT][1] = amove->det.ail.from_nr;
			break;
 	case BISHOP: 	
 			board.bishops ^= fromto;
			if (board.w_figpos[BISHOP][0] == amove->det.ail.to_nr) board.w_figpos[BISHOP][0] = amove->det.ail.from_nr;
				else board.w_figpos[BISHOP][1] = amove->det.ail.from_nr;
			break;
 	case ROOK: 	
 			board.rooks ^= fromto;
			if (board.w_figpos[ROOK][0] == amove->det.ail.to_nr) board.w_figpos[ROOK][0] = amove->det.ail.from_nr;
				else board.w_figpos[ROOK][1] = amove->det.ail.from_nr;
			break;
 	case QUEEN: 	
 			board.queens ^= fromto;
			board.w_figpos[QUEEN][0] = amove->det.ail.from_nr;
			break;
 	case KING: 	
 			board.kings ^= fromto;
			board.w_figpos[KING][0] = amove->det.ail.from_nr;
			break;
 };

 board.array64[amove->det.ail.from_nr] = amove->det.ail.piece;
 wtm = ~wtm;

 if( (amove->det.ail.flags & SPECIAL_MOVE) == 0)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & PAWN_TWO_STEPS)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & NORMAL_CAPTURE)
 {

	 board.array64[amove->det.ail.to_nr] = amove->det.ail.captured;	
         tree.matbilanz -= piece_value[-amove->det.ail.captured];

// set the bit of the captured piece in the bitboards by ORing them
// with to !

   	 board.b_occ |= amove->to;

	 switch(amove->det.ail.captured)
	 {
 		case -PAWN: 	
 				board.pawns |= amove->to;
				break;
 		case -KNIGHT: 	
 				board.knights |= amove->to;
				if (board.b_figpos[KNIGHT][0] == -amove->det.ail.to_nr) board.b_figpos[KNIGHT][0] = amove->det.ail.to_nr;
					else board.b_figpos[KNIGHT][1] = amove->det.ail.to_nr;
				break;
 		case -BISHOP: 	
 				board.bishops |= amove->to;
				if (board.b_figpos[BISHOP][0] == -amove->det.ail.to_nr) board.b_figpos[BISHOP][0] = amove->det.ail.to_nr;
					else board.b_figpos[BISHOP][1] = amove->det.ail.to_nr;
				break;
	 	case -ROOK: 	
 				board.rooks |= amove->to;
				if (board.b_figpos[ROOK][0] == -amove->det.ail.to_nr) board.b_figpos[ROOK][0] = amove->det.ail.to_nr;
					else board.b_figpos[ROOK][1] = amove->det.ail.to_nr;
				break;
	 	case -QUEEN: 	
 				board.queens |= amove->to;
				board.b_figpos[QUEEN][0] = amove->det.ail.to_nr;
				break;
	 	case -KING: 	
	 			board.kings |= amove->to;
				board.b_figpos[KING][0] = amove->det.ail.to_nr;
//				printf("ERROR: ATTEMPTED TO UNDO WHITE CAPTURE OF BLACK KING !");	
 				break;
	 };
	
  return 0;
 };

// handling special moves: castling, en-passent, promoting, promote+capture ... to be written !

}

int undo_move_b(move *amove)
{
 register long long fromto = amove->from | amove->to;	

// set the from bit and clear the to bit in the bitboards in only one
// step by using XOR !

 board.b_occ ^= fromto;
 board.occ.ll ^= fromto;

 board.occ_l90.ll ^= ( bit_l90[amove->det.ail.from_nr] | bit_l90[amove->det.ail.to_nr] );
 board.occ_a1h8.ll ^= ( bit_a1h8[amove->det.ail.from_nr] | bit_a1h8[amove->det.ail.to_nr] );
 board.occ_a8h1.ll ^= ( bit_a8h1[amove->det.ail.from_nr] | bit_a8h1[amove->det.ail.to_nr] );

 switch(amove->det.ail.piece)
 {
 	case -PAWN: 	
 			board.pawns ^= fromto;
			break;
 	case -KNIGHT: 	
 			board.knights ^= fromto;
			if (board.b_figpos[KNIGHT][0] == amove->det.ail.to_nr) board.b_figpos[KNIGHT][0] = amove->det.ail.from_nr;
				else board.b_figpos[KNIGHT][1] = amove->det.ail.from_nr;
			break;
 	case -BISHOP: 	
 			board.bishops ^= fromto;
			if (board.b_figpos[BISHOP][0] == amove->det.ail.to_nr) board.b_figpos[BISHOP][0] = amove->det.ail.from_nr;
				else board.b_figpos[BISHOP][1] = amove->det.ail.from_nr;
			break;
 	case -ROOK: 	
 			board.rooks ^= fromto;
			if (board.b_figpos[ROOK][0] == amove->det.ail.to_nr) board.b_figpos[ROOK][0] = amove->det.ail.from_nr;
				else board.b_figpos[ROOK][1] = amove->det.ail.from_nr;
			break;
 	case -QUEEN: 	
 			board.queens ^= fromto;
			board.b_figpos[QUEEN][0] = amove->det.ail.from_nr;
			break;
 	case -KING: 	
 			board.kings ^= fromto;
			board.b_figpos[KING][0] = amove->det.ail.from_nr;
			break;
 };

 board.array64[amove->det.ail.from_nr] = amove->det.ail.piece;
 wtm = ~wtm;

 if( (amove->det.ail.flags & SPECIAL_MOVE) == 0)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & PAWN_TWO_STEPS)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & NORMAL_CAPTURE)
 {

	 board.array64[amove->det.ail.to_nr] = amove->det.ail.captured;	
         tree.matbilanz += piece_value[amove->det.ail.captured];

// set the bit of the captured piece in the bitboards by ORing them
// with to !

	 board.w_occ |= amove->to;

	 switch(amove->det.ail.captured)
	 {
 		case PAWN: 	
 				board.pawns |= amove->to;
				break;
 		case KNIGHT: 	
 				board.knights |= amove->to;
				if (board.w_figpos[KNIGHT][0] == -amove->det.ail.to_nr) board.w_figpos[KNIGHT][0] = amove->det.ail.to_nr;
					else board.w_figpos[KNIGHT][1] = amove->det.ail.to_nr;
				break;
 		case BISHOP: 	
 				board.bishops |= amove->to;
				if (board.w_figpos[BISHOP][0] == -amove->det.ail.to_nr) board.w_figpos[BISHOP][0] = amove->det.ail.to_nr;
					else board.w_figpos[BISHOP][1] = amove->det.ail.to_nr;
				break;
	 	case ROOK: 	
 				board.rooks |= amove->to;
				if (board.w_figpos[ROOK][0] == -amove->det.ail.to_nr) board.w_figpos[ROOK][0] = amove->det.ail.to_nr;
					else board.w_figpos[ROOK][1] = amove->det.ail.to_nr;
				break;
	 	case QUEEN: 	
 				board.queens |= amove->to;
				board.w_figpos[QUEEN][0] = amove->det.ail.to_nr;
				break;
	 	case KING: 	
	 			board.kings |= amove->to;
				board.w_figpos[KING][0] = amove->det.ail.to_nr;
//				printf("ERROR: ATTEMPTED TO UNDO WHITE CAPTURE OF BLACK KING !");	
 				break;
	 };
	
  return 0;
 };

// handling special moves: castling, en-passent, promoting, promote+capture ... to be written !

}

#endif