//	JOX - joes own chess system	
//
//
//  File UNMAKE.CC contains unmake_move routines for black and white
//
//
// last modified: 17.8.99


#if !defined(UNMAKE_CC)
#define UNMAKE_C

#include <global.h>
#include <stdio.h>

int undo_move_w(move *amove)
{
 register long long fromto = amove->from | amove->to;	

// set the from bit and clear the to bit in the bitboards in only one
// step by using XOR !

 board.w_occ ^= fromto;
 board.occ.ll ^= fromto;

 board.occ_l90.ll ^= ( bit_l90[amove->det.ail.from_nr] | bit_l90[amove->det.ail.to_nr] );
 board.occ_a1h8.ll ^= ( bit_a1h8[amove->det.ail.from_nr] | bit_a1h8[amove->det.ail.to_nr] );
 board.occ_a8h1.ll ^= ( bit_a8h1[amove->det.ail.from_nr] | bit_a8h1[amove->det.ail.to_nr] );

 switch(amove->det.ail.piece)
 {
 	case PAWN: 	
 			board.pawns ^= fromto;
			break;
 	case KNIGHT: 	
 			board.knights ^= fromto;
			break;
 	case BISHOP: 	
 			board.bishops ^= fromto;
			break;
 	case ROOK: 	
 			board.rooks ^= fromto;
			break;
 	case QUEEN: 	
 			board.queens ^= fromto;
			break;
 	case KING: 	
 			board.kings ^= fromto;
			break;
 };

 board.array64[amove->det.ail.from_nr] = amove->det.ail.piece;
 wtm = ~wtm;

 if( (amove->det.ail.flags & SPECIAL_MOVE) == 0)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & PAWN_TWO_STEPS)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & NORMAL_CAPTURE)
 {

	 board.array64[amove->det.ail.to_nr] = amove->det.ail.captured;	
         tree.matbilanz -= piece_value[-amove->det.ail.captured];

// set the bit of the captured piece in the bitboards by ORing them
// with to !

   	 board.b_occ |= amove->to;

	 switch(amove->det.ail.captured)
	 {
 		case -PAWN: 	
 				board.pawns |= amove->to;
				break;
 		case -KNIGHT: 	
 				board.knights |= amove->to;
				break;
 		case -BISHOP: 	
 				board.bishops |= amove->to;
				break;
	 	case -ROOK: 	
 				board.rooks |= amove->to;
				break;
	 	case -QUEEN: 	
 				board.queens |= amove->to;
				break;
	 	case -KING: 	
	 			board.kings |= amove->to;
//				printf("ERROR: ATTEMPTED TO UNDO WHITE CAPTURE OF BLACK KING !");	
 				break;
	 };
	
  return 0;
 };

// handling special moves: castling, en-passent, promoting, promote+capture ... to be written !

}

int undo_move_b(move *amove)
{
 register long long fromto = amove->from | amove->to;	

// set the from bit and clear the to bit in the bitboards in only one
// step by using XOR !

 board.b_occ ^= fromto;
 board.occ.ll ^= fromto;

 board.occ_l90.ll ^= ( bit_l90[amove->det.ail.from_nr] | bit_l90[amove->det.ail.to_nr] );
 board.occ_a1h8.ll ^= ( bit_a1h8[amove->det.ail.from_nr] | bit_a1h8[amove->det.ail.to_nr] );
 board.occ_a8h1.ll ^= ( bit_a8h1[amove->det.ail.from_nr] | bit_a8h1[amove->det.ail.to_nr] );

 switch(amove->det.ail.piece)
 {
 	case -PAWN: 	
 			board.pawns ^= fromto;
			break;
 	case -KNIGHT: 	
 			board.knights ^= fromto;
			break;
 	case -BISHOP: 	
 			board.bishops ^= fromto;
			break;
 	case -ROOK: 	
 			board.rooks ^= fromto;
			break;
 	case -QUEEN: 	
 			board.queens ^= fromto;
			break;
 	case -KING: 	
 			board.kings ^= fromto;
			break;
 };

 board.array64[amove->det.ail.from_nr] = amove->det.ail.piece;
 wtm = ~wtm;

 if( (amove->det.ail.flags & SPECIAL_MOVE) == 0)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & PAWN_TWO_STEPS)
 {
        board.array64[amove->det.ail.to_nr] = 0;
	return 0;
 };

 if(amove->det.ail.flags & NORMAL_CAPTURE)
 {

	 board.array64[amove->det.ail.to_nr] = amove->det.ail.captured;	
         tree.matbilanz += piece_value[amove->det.ail.captured];

// set the bit of the captured piece in the bitboards by ORing them
// with to !

	 board.w_occ |= amove->to;

	 switch(amove->det.ail.captured)
	 {
 		case PAWN: 	
				board.pawns |= amove->to;
				break;
 		case KNIGHT: 	
 				board.knights |= amove->to;
				break;
 		case BISHOP: 	
 				board.bishops |= amove->to;
				break;
	 	case ROOK: 	
 				board.rooks |= amove->to;
				break;
	 	case QUEEN: 	
 				board.queens |= amove->to;
				break;
	 	case KING: 	
	 			board.kings |= amove->to;
//				printf("ERROR: ATTEMPTED TO UNDO BLACK CAPTURE OF WHITE KING !");
				break;
	 };
	
  return 0;
 };

// handling special moves: castling, en-passent, promoting, promote+capture ... to be written !

}

#endif