//	JOX - joes own chess system	
//
//
//  File UTIL_CC contains utils (amazing, eh ;-))
//
//
// last modified: 17.8.99


#if !defined(UTIL_CC)
#define UTIL_CC

#include <global.h>
#include <stdio.h>

char get_LSB_nr(long long b)	// returns the nr of the LSB (least significant bit)
					// get_LSB_nr(0)= -1 !!!!!
{
 char nr;
 if (  (nr = (bitnr[b & 0xFFFF]) + 1))	// to gain performance (hopefully)
					// is equivalent to: if ( (nr = (bitnr[b & 0xFFFF])) != -1)					
					// tests if a bit is set (-> birnr[] != -1) in b word by word
   return (nr - 1);
 else if ( (nr = (bitnr[(b = b >> 16) & 0xFFFF]) + 1) )
   return (nr + 15);
 else if ( nr = (bitnr[(b = b >> 16) & 0xFFFF] + 1) )
   return (nr + 31);
 else if ( nr = (bitnr[(b = b >> 16) & 0xFFFF] + 1) )
   return (nr + 47);
 return -1;
}

int display_bitboard(long long b)
{
   for(int y=56; y >= 0; y -= 8)
	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf("\n");
		if( (b & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

}

int display_board_bitboards()
{
   printf("\n");
   for (int i =0; i<12; i++)
   {
	if (i == 0) printf("  w_occ  ");
	if (i == 1) printf("  b_occ  ");
	if (i == 2) printf("  pawns  ");
	if (i == 3) printf(" knights ");
	if (i == 4) printf(" bishops ");
	if (i == 5) printf("  rooks  ");
	if (i == 6) printf(" queens  ");
	if (i == 7) printf("  kings  ");
	if (i == 8) printf("   occ   ");
	if (i == 9) printf(" occ_l90 ");
	if (i == 10) printf("occ_a1h8 ");
	if (i == 11) printf("occ_a8h1 ");
   };

   for(int y=56; y >= 0; y -= 8)
   {

	printf("\n");
	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.w_occ & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.b_occ & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.pawns & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.knights & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.bishops & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.rooks & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.queens & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.kings & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.occ.ll & bit[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.occ_l90.ll & bit_l90[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.occ_a1h8.ll & bit_a1h8[y+x]) == 0) printf("0"); else printf("1");
       	   };

	for(int x=0;x<8;x++)
	   {
                if(x == 0) printf(" ");
		if( (board.occ_a8h1.ll & bit_a8h1[y+x]) == 0) printf("0"); else printf("1");
      	   };

   };

}

int get64(int p120)
{
 int s,z;
 s = (p120 % 10);
 z = (p120 / 10) - 1;
 return ( ((z-1)*8) + s - 1);
}

int get120(int p64)
{
 int s,z;
 s = p64 % 8;
 z = (p64 / 8) + 1;
 return ( ((z+1) *10) + s + 1);
}

position convert_120_bb(char *p120)
{
 long long temp;
 position pbb;

 pbb.pawns = 0;
 pbb.knights = 0;
 pbb.bishops = 0;
 pbb.rooks = 0;
 pbb.queens = 0;
 pbb.kings = 0;
 pbb.w_occ = 0;
 pbb.b_occ = 0;
 pbb.occ.ll = 0;
 pbb.occ_l90.ll = 0;
 pbb.occ_a1h8.ll = 0;
 pbb.occ_a8h1.ll = 0;
 pbb.w_attacks = 0;
 pbb.b_attacks = 0;

 for (int i=21;i < 99; i++)
 {
	switch (p120[i])
	{
		case 1:		pbb.pawns |= bit[get64(i)];
				pbb.w_occ |= bit[get64(i)];
			break;
		case 2:		pbb.knights |= bit[get64(i)];
				pbb.w_occ |= bit[get64(i)];
			break;
		case 3:		pbb.bishops |= bit[get64(i)];
				pbb.w_occ |= bit[get64(i)];
			break;
		case 4:		pbb.rooks |= bit[get64(i)];
				pbb.w_occ |= bit[get64(i)];
			break;
		case 5:		pbb.queens |= bit[get64(i)];
				pbb.w_occ |= bit[get64(i)];
			break;
		case 6:		pbb.kings |= bit[get64(i)];
				pbb.w_occ |= bit[get64(i)];
			break;

		case -1: 	pbb.pawns |= bit[get64(i)];
				pbb.b_occ |= bit[get64(i)];
			break;
		case -2:	pbb.knights |= bit[get64(i)];
				pbb.b_occ |= bit[get64(i)];
			break;
		case -3:	pbb.bishops |= bit[get64(i)];
				pbb.b_occ |= bit[get64(i)];
			break;
		case -4:	pbb.rooks |= bit[get64(i)];
				pbb.b_occ |= bit[get64(i)];
			break;
		case -5:	pbb.queens |= bit[get64(i)];
				pbb.b_occ |= bit[get64(i)];
			break;
		case -6:	pbb.kings |= bit[get64(i)];
				pbb.b_occ |= bit[get64(i)];
			break;

	};
 };
 pbb.occ.ll = pbb.w_occ | pbb.b_occ;

 for (int i= 0; i<64;i++)
 {
	pbb.array64[i] = p120[get120(i)];
	if (pbb.occ.ll & bit[i])
	{
		pbb.occ_l90.ll |= bit[l90_to_normal[i]];
                pbb.occ_a1h8.ll |= bit[a1h8_to_normal[i]];
		pbb.occ_a8h1.ll |= bit[a8h1_to_normal[i]];
	};
 };
 pbb.flags = MAY_WHITE_CASTLE_LONG | MAY_WHITE_CASTLE_SHORT | MAY_BLACK_CASTLE_SHORT | MAY_BLACK_CASTLE_SHORT;


// now set the w_figpos and b_figpos arrays according to the bitboards:

 temp = pbb.knights & pbb.w_occ;
 pbb.w_figpos[KNIGHT][0] = get_LSB_nr(temp);
 CLEAR_LSB(temp);
 pbb.w_figpos[KNIGHT][1] = get_LSB_nr(temp);

 temp = pbb.bishops & pbb.w_occ;
 pbb.w_figpos[BISHOP][0] = get_LSB_nr(temp);
 CLEAR_LSB(temp);
 pbb.w_figpos[BISHOP][1] = get_LSB_nr(temp);

 temp = pbb.rooks & pbb.w_occ;
 pbb.w_figpos[ROOK][0] = get_LSB_nr(temp);
 CLEAR_LSB(temp);
 pbb.w_figpos[ROOK][1] = get_LSB_nr(temp);

 temp = pbb.queens & pbb.w_occ;
 pbb.w_figpos[QUEEN][0] = get_LSB_nr(temp);

 temp = pbb.kings & pbb.w_occ;
 pbb.w_figpos[KING][0] = get_LSB_nr(temp);

 temp = pbb.knights & pbb.b_occ;
 pbb.b_figpos[KNIGHT][0] = get_LSB_nr(temp);
 CLEAR_LSB(temp);
 pbb.b_figpos[KNIGHT][1] = get_LSB_nr(temp);

 temp = pbb.bishops & pbb.b_occ;
 pbb.b_figpos[BISHOP][0] = get_LSB_nr(temp);
 CLEAR_LSB(temp);
 pbb.b_figpos[BISHOP][1] = get_LSB_nr(temp);

 temp = pbb.rooks & pbb.b_occ;
 pbb.b_figpos[ROOK][0] = get_LSB_nr(temp);
 CLEAR_LSB(temp);
 pbb.b_figpos[ROOK][1] = get_LSB_nr(temp);

 temp = pbb.queens & pbb.b_occ;
 pbb.b_figpos[QUEEN][0] = get_LSB_nr(temp);

 temp = pbb.kings & pbb.b_occ;
 pbb.b_figpos[KING][0] = get_LSB_nr(temp);

     	
 return pbb;
}

int display_board()
{
 int i,anfang,ende,step;
 char array120[120];
 for ( i=0; i<120; i++) array120[i] = ausgangs[i];
 for ( i=0; i<64; i++) array120[get120(i)] = board.array64[i];
 if (user_colour == WHITE) {anfang=90;ende=10; step=-10; } else { anfang=20; ende=100; step=10; };
 printf("\n**************************************");
 printf("\n*** A   B   C   D   E   F   G   H  ***");
 printf("\n**************************************\n");
 for (int x=anfang;x!=ende;x+=step)
  for(int y=0;y<10;y++)
   {
    switch(array120[x+y])
     {
      case 0: printf(" -- "); break;
      case 1: printf(" WB "); break;
      case 2: printf(" WS "); break;
      case 3: printf(" WL "); break;
      case 4: printf(" WT "); break;
      case 5: printf(" WD "); break;
      case 6: printf(" WK "); break;
      case -1: printf(" SB "); break;
      case -2: printf(" SS "); break;
      case -3: printf(" SL "); break;
      case -4: printf(" ST "); break;
      case -5: printf(" SD "); break;
      case -6: printf(" SK "); break;
      case 100: printf("*%d*",x/10-1); break;
     };
     if(y==9) printf("\n");
   };
 printf("**************************************\n");
 printf("*** A   B   C   D   E   F   G   H  ***\n");
 printf("**************************************\n\n");
 return 0;
}


// returns 1 if mv is a valid move in the current position, else returns 0 !

int check_move(int from, int to, move* mv)
{
 int nr;
 move ml[200];
 if (wtm) nr = movegen_w(ml,board.occ.ll,-1); else  nr = movegen_b(ml,board.occ.ll,-1);
 for(int i = 0; i < nr; i++)
 {
 	if ( (ml[i].from == bit[from]) && (ml[i].to == bit[to]) )
	{
	        (*mv) = ml[i];
		return 1;
	};
 };
 return 0;
}	

// extracts mv from input_buffer and returns 1 if mv is a valid move in the current position, else returns 0 !

int get_move(char *input_buffer,move *mv,int wtm)
{
 int file,rank,from,to;

// extract from-field

	file = input_buffer[0] - 'a';
	rank = input_buffer[1] - '1';
        from = (rank << 3) | file;
        if ( (from < 0) || (from > 63)) return 0;
	
// extract to-field

	file = input_buffer[2] - 'a';
	rank = input_buffer[3] - '1';
	to = (rank << 3) | file;
	if ( (to < 0) || (to > 63)) return 0;

// check if move is in movelist

 	return check_move(from,to,mv);
}

void feldsn(char feld, char * sn)
{
 sn[0]=snspalte[feld % 10];
 sn[1]= (feld / 10-1) + '0';
}

#endif
